/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.transports;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.SASL;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.spi.IMessageReader;
import org.freedesktop.dbus.spi.IMessageWriter;
import org.freedesktop.dbus.spi.ISocketProvider;
import org.freedesktop.dbus.spi.InputStreamMessageReader;
import org.freedesktop.dbus.spi.OutputStreamMessageWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AbstractTransport
implements Closeable {
    ServiceLoader<ISocketProvider> spiLoader = ServiceLoader.load(ISocketProvider.class);
    private final Logger logger;
    private final BusAddress address;
    private SASL.SaslMode saslMode;
    private int saslAuthMode;
    private IMessageReader inputReader;
    private IMessageWriter outputWriter;
    private boolean fileDescriptorSupported;

    AbstractTransport(BusAddress _address) {
        this.address = _address;
        this.saslMode = _address.isListeningSocket() ? SASL.SaslMode.SERVER : SASL.SaslMode.CLIENT;
        this.saslAuthMode = 0;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public void writeMessage(Message _msg) throws IOException {
        if (!this.fileDescriptorSupported && 104 == _msg.getType()) {
            throw new IllegalArgumentException("File descriptors are not supported!");
        }
        if (this.outputWriter == null || this.outputWriter.isClosed()) {
            throw new IOException("OutputWriter already closed or null");
        }
        this.outputWriter.writeMessage(_msg);
    }

    public Message readMessage() throws IOException, DBusException {
        if (this.inputReader != null && !this.inputReader.isClosed()) {
            return this.inputReader.readMessage();
        }
        throw new IOException("InputReader already closed or null");
    }

    abstract void connect() throws IOException;

    abstract boolean hasFileDescriptorSupport();

    protected void authenticate(OutputStream _out, InputStream _in, Socket _sock) throws IOException {
        SASL sasl = new SASL(this.hasFileDescriptorSupport());
        if (!sasl.auth(this.saslMode, this.saslAuthMode, this.address.getGuid(), _out, _in, _sock)) {
            _out.close();
            throw new IOException("Failed to auth");
        }
        this.fileDescriptorSupported = sasl.isFileDescriptorSupported();
    }

    protected void setInputOutput(Socket _socket) {
        try {
            for (ISocketProvider provider : this.spiLoader) {
                this.logger.debug("Found ISocketProvider {}", (Object)provider);
                provider.setFileDescriptorSupport(this.hasFileDescriptorSupport() && this.fileDescriptorSupported);
                this.inputReader = provider.createReader(_socket);
                this.outputWriter = provider.createWriter(_socket);
                if (this.inputReader == null || this.outputWriter == null) continue;
                this.logger.debug("Using ISocketProvider {}", (Object)provider);
                break;
            }
        }
        catch (ServiceConfigurationError _ex) {
            this.logger.error("Could not initialize service provider.", (Throwable)_ex);
        }
        catch (IOException _ex) {
            this.logger.error("Could not initialize alternative message reader/writer.", (Throwable)_ex);
        }
        try {
            if (this.inputReader == null || this.outputWriter == null) {
                this.logger.debug("No alternative ISocketProvider found, using built-in implementation.  inputReader = {}, outputWriter = {}", (Object)this.inputReader, (Object)this.outputWriter);
                this.inputReader = new InputStreamMessageReader(_socket.getInputStream());
                this.outputWriter = new OutputStreamMessageWriter(_socket.getOutputStream());
            }
        }
        catch (IOException _ex) {
            this.logger.error("Could not initialize default message reader/writer.", (Throwable)_ex);
        }
    }

    protected int getSaslAuthMode() {
        return this.saslAuthMode;
    }

    protected void setSaslAuthMode(int _saslAuthMode) {
        this.saslAuthMode = _saslAuthMode;
    }

    protected SASL.SaslMode getSaslMode() {
        return this.saslMode;
    }

    protected void setSaslMode(SASL.SaslMode _saslMode) {
        this.saslMode = _saslMode;
    }

    protected BusAddress getAddress() {
        return this.address;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public void close() throws IOException {
        this.inputReader.close();
        this.outputWriter.close();
    }
}

