/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel.contexts;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.PatternExpr;
import com.github.javaparser.resolution.Context;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.javaparsermodel.contexts.AbstractJavaParserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class BinaryExprContext
extends AbstractJavaParserContext<BinaryExpr> {
    public BinaryExprContext(BinaryExpr wrappedNode, TypeSolver typeSolver) {
        super(wrappedNode, typeSolver);
    }

    public List<PatternExpr> patternExprsExposedFromChildren() {
        BinaryExpr binaryExpr = (BinaryExpr)this.wrappedNode;
        Expression leftBranch = binaryExpr.getLeft();
        Expression rightBranch = binaryExpr.getRight();
        ArrayList<PatternExpr> results = new ArrayList<PatternExpr>();
        if (binaryExpr.getOperator().equals((Object)BinaryExpr.Operator.EQUALS)) {
            if (rightBranch.isBooleanLiteralExpr()) {
                if (rightBranch.asBooleanLiteralExpr().getValue()) {
                    results.addAll(this.patternExprsExposedToDirectParentFromBranch(leftBranch));
                }
            } else if (leftBranch.isBooleanLiteralExpr() && leftBranch.asBooleanLiteralExpr().getValue()) {
                results.addAll(this.patternExprsExposedToDirectParentFromBranch(rightBranch));
            }
        } else if (binaryExpr.getOperator().equals((Object)BinaryExpr.Operator.NOT_EQUALS)) {
            if (rightBranch.isBooleanLiteralExpr()) {
                if (!rightBranch.asBooleanLiteralExpr().getValue()) {
                    results.addAll(this.patternExprsExposedToDirectParentFromBranch(leftBranch));
                }
            } else if (leftBranch.isBooleanLiteralExpr() && !leftBranch.asBooleanLiteralExpr().getValue()) {
                results.addAll(this.patternExprsExposedToDirectParentFromBranch(rightBranch));
            }
        } else if (binaryExpr.getOperator().equals((Object)BinaryExpr.Operator.AND)) {
            results.addAll(this.patternExprsExposedToDirectParentFromBranch(leftBranch));
            results.addAll(this.patternExprsExposedToDirectParentFromBranch(rightBranch));
        } else {
            return new ArrayList<PatternExpr>();
        }
        return results;
    }

    public List<PatternExpr> negatedPatternExprsExposedFromChildren() {
        BinaryExpr binaryExpr = (BinaryExpr)this.wrappedNode;
        Expression leftBranch = binaryExpr.getLeft();
        Expression rightBranch = binaryExpr.getRight();
        ArrayList<PatternExpr> results = new ArrayList<PatternExpr>();
        if (binaryExpr.getOperator().equals((Object)BinaryExpr.Operator.EQUALS)) {
            if (rightBranch.isBooleanLiteralExpr()) {
                if (!this.isDefinitivelyTrue(rightBranch)) {
                    results.addAll(this.patternExprsExposedToDirectParentFromBranch(leftBranch));
                }
            } else if (leftBranch.isBooleanLiteralExpr() && !this.isDefinitivelyTrue(leftBranch)) {
                results.addAll(this.patternExprsExposedToDirectParentFromBranch(rightBranch));
            }
        } else if (binaryExpr.getOperator().equals((Object)BinaryExpr.Operator.NOT_EQUALS)) {
            if (rightBranch.isBooleanLiteralExpr()) {
                if (this.isDefinitivelyTrue(rightBranch)) {
                    results.addAll(this.patternExprsExposedToDirectParentFromBranch(leftBranch));
                }
            } else if (leftBranch.isBooleanLiteralExpr() && this.isDefinitivelyTrue(leftBranch)) {
                results.addAll(this.patternExprsExposedToDirectParentFromBranch(rightBranch));
            }
        } else if (binaryExpr.getOperator().equals((Object)BinaryExpr.Operator.AND)) {
            results.addAll(this.negatedPatternExprsExposedToDirectParentFromBranch(leftBranch));
            results.addAll(this.negatedPatternExprsExposedToDirectParentFromBranch(rightBranch));
        } else {
            return new ArrayList<PatternExpr>();
        }
        return results;
    }

    private List<PatternExpr> patternExprsExposedToDirectParentFromBranch(Expression branch) {
        if (branch.isEnclosedExpr() || branch.isBinaryExpr() || branch.isUnaryExpr() || branch.isInstanceOfExpr()) {
            Context branchContext = JavaParserFactory.getContext((Node)branch, this.typeSolver);
            return branchContext.patternExprsExposedFromChildren();
        }
        return new ArrayList<PatternExpr>();
    }

    private List<PatternExpr> negatedPatternExprsExposedToDirectParentFromBranch(Expression branch) {
        if (branch.isEnclosedExpr() || branch.isBinaryExpr() || branch.isUnaryExpr() || branch.isInstanceOfExpr()) {
            Context branchContext = JavaParserFactory.getContext((Node)branch, this.typeSolver);
            return branchContext.negatedPatternExprsExposedFromChildren();
        }
        return new ArrayList<PatternExpr>();
    }

    public List<PatternExpr> patternExprsExposedToChild(Node child) {
        BinaryExpr binaryExpr = (BinaryExpr)this.wrappedNode;
        Expression leftBranch = binaryExpr.getLeft();
        Expression rightBranch = binaryExpr.getRight();
        ArrayList<PatternExpr> results = new ArrayList<PatternExpr>();
        if (child == leftBranch) {
            results.addAll(this.patternExprsExposedToDirectParentFromBranch(leftBranch));
        } else if (child == rightBranch && binaryExpr.getOperator().equals((Object)BinaryExpr.Operator.AND)) {
            results.addAll(this.patternExprsExposedToDirectParentFromBranch(leftBranch));
        }
        return results;
    }

    public Optional<PatternExpr> patternExprInScope(String name) {
        BinaryExpr binaryExpr = (BinaryExpr)this.wrappedNode;
        Expression leftBranch = binaryExpr.getLeft();
        Expression rightBranch = binaryExpr.getRight();
        List<PatternExpr> patternExprs = this.patternExprsExposedToDirectParentFromBranch(leftBranch);
        Optional<PatternExpr> localResolutionResults = patternExprs.stream().filter(vd -> vd.getNameAsString().equals(name)).findFirst();
        if (localResolutionResults.isPresent()) {
            return localResolutionResults;
        }
        if (!this.getParent().isPresent()) {
            return Optional.empty();
        }
        Context parentContext = this.getParent().get();
        return parentContext.patternExprInScope(name);
    }

    private boolean isDefinitivelyTrue(Expression expression) {
        return expression.isBooleanLiteralExpr() && expression.asBooleanLiteralExpr().getValue();
    }

    private boolean isDefinitivelyFalse(Expression expression) {
        return expression.isBooleanLiteralExpr() && !expression.asBooleanLiteralExpr().getValue();
    }
}

