/*
 * (c) Copyright 2009-2010 by Volker Bergmann. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, is permitted under the terms of the
 * GNU Lesser General Public License (LGPL), Eclipse Public License (EPL)
 * and the BSD License.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * WITHOUT A WARRANTY OF ANY KIND. ALL EXPRESS OR IMPLIED CONDITIONS,
 * REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE
 * HEREBY EXCLUDED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

package com.github.javatlacati.contiperf.junit;

import com.github.javatlacati.contiperf.Invoker;
import com.github.javatlacati.contiperf.util.ContiPerfUtil;
import org.junit.runners.model.Statement;

/**
 * {@link Invoker} implementation for JUnit 4.7+.<br>
 * <br>
 * Created: 22.10.2009 16:55:12
 * 
 * @since 1.0
 * @author Volker Bergmann
 */
public class JUnitInvoker implements Invoker {

    private String id;
    private Statement base;

    public JUnitInvoker(String id, Statement base) {
	this.id = id;
	this.base = base;
    }

    public String getId() {
	return id;
    }

    public Object invoke(Object[] args) throws Exception {
	try {
	    base.evaluate();
	    return null;
	} catch (Throwable e) {
	    throw ContiPerfUtil.executionError(e);
	}
    }

}
