/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDBlobInputStream;
import cubrid.jdbc.driver.CUBRIDBlobOutputStream;
import cubrid.jdbc.driver.CUBRIDBufferedInputStream;
import cubrid.jdbc.driver.CUBRIDBufferedOutputStream;
import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDLobHandle;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;

public class CUBRIDBlob
implements Blob {
    private static final int BLOB_MAX_IO_LENGTH = 131072;
    private CUBRIDConnection conn;
    private boolean isWritable;
    private CUBRIDLobHandle lobHandle;
    private ArrayList<Flushable> streamList = new ArrayList();

    public CUBRIDBlob(CUBRIDConnection conn) throws SQLException {
        if (conn == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        byte[] packedLobHandle = conn.lobNew(23);
        this.conn = conn;
        this.isWritable = true;
        this.lobHandle = new CUBRIDLobHandle(23, packedLobHandle);
    }

    public CUBRIDBlob(CUBRIDConnection conn, byte[] packedLobHandle) throws SQLException {
        if (conn == null || packedLobHandle == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        this.conn = conn;
        this.isWritable = false;
        this.lobHandle = new CUBRIDLobHandle(23, packedLobHandle);
    }

    public long length() throws SQLException {
        if (this.lobHandle == null) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        return this.lobHandle.getLobSize();
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (this.lobHandle == null) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        if (pos < 1L || length < 0) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        if (length == 0) {
            return new byte[0];
        }
        int total_read_len = 0;
        if (--pos + (long)length > this.length()) {
            length = (int)(this.length() - pos);
        }
        if (length <= 0) {
            return new byte[0];
        }
        byte[] buf = new byte[length];
        while (length > 0) {
            int read_len = Math.min(length, 131072);
            int real_read_len = this.conn.lobRead(this.lobHandle.getPackedLobHandle(), pos, buf, total_read_len, read_len);
            pos += (long)real_read_len;
            length -= real_read_len;
            total_read_len += real_read_len;
            if (real_read_len != 0) continue;
        }
        if (total_read_len < buf.length) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.unknown, null);
        }
        return buf;
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.getBinaryStream(1L, this.length());
    }

    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        if (this.lobHandle == null) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        if (pos < 1L || length < 0L) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        return new CUBRIDBufferedInputStream(new CUBRIDBlobInputStream(this, pos, length), 131072);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public long position(Blob pattern, long start) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (this.lobHandle == null) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        if (pos < 1L || offset < 0 || len < 0) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        if (offset + len > bytes.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isWritable) {
            if (this.length() + 1L != pos) {
                throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.lob_pos_invalid, null);
            }
            --pos;
            int total_write_len = 0;
            while (len > 0) {
                int write_len = Math.min(len, 131072);
                int real_write_len = this.conn.lobWrite(this.lobHandle.getPackedLobHandle(), pos, bytes, offset, write_len);
                pos += (long)real_write_len;
                len -= real_write_len;
                offset += real_write_len;
                total_write_len += real_write_len;
            }
            if (pos > this.length()) {
                this.lobHandle.setLobSize(pos);
            }
            return total_write_len;
        }
        throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.lob_is_not_writable, null);
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        if (this.lobHandle == null) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        if (pos < 1L) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        if (this.isWritable) {
            if (this.length() + 1L != pos) {
                throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.lob_pos_invalid, null);
            }
            CUBRIDBufferedOutputStream out = new CUBRIDBufferedOutputStream(new CUBRIDBlobOutputStream(this, pos), 131072);
            this.addFlushableStream(out);
            return out;
        }
        throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.lob_is_not_writable, null);
    }

    public void truncate(long len) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void free() throws SQLException {
        this.conn = null;
        this.lobHandle = null;
        this.streamList = null;
        this.isWritable = false;
    }

    public CUBRIDLobHandle getLobHandle() {
        return this.lobHandle;
    }

    private void addFlushableStream(Flushable out) {
        this.streamList.add(out);
    }

    public void removeFlushableStream(Flushable out) {
        this.streamList.remove(out);
    }

    public void flushFlushableStreams() {
        if (!this.streamList.isEmpty()) {
            for (Flushable out : this.streamList) {
                try {
                    out.flush();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String toString() {
        return this.lobHandle.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CUBRIDBlob) {
            CUBRIDBlob that = (CUBRIDBlob)obj;
            return this.lobHandle.equals(that.lobHandle);
        }
        return false;
    }
}

