/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDBlob;
import cubrid.jdbc.driver.CUBRIDClob;
import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDPreparedStatement;
import cubrid.jdbc.jci.UStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CUBRIDCallableStatement
extends CUBRIDPreparedStatement
implements CallableStatement {
    private boolean was_null;

    protected CUBRIDCallableStatement(CUBRIDConnection c, UStatement us) {
        super(c, us, 1003, 1007, 2, 2);
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkIsOpen();
        return this.was_null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int index) throws SQLException {
        int value;
        this.checkIsOpen();
        this.beforeGetValue(index);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getInt(index);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int index) throws SQLException {
        String value;
        Object obj;
        this.checkIsOpen();
        this.beforeGetValue(index);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            obj = this.u_stmt.getObject(index);
            this.error = this.u_stmt.getRecentError();
        }
        if (obj != null && obj instanceof Clob) {
            Clob clob = (Clob)obj;
            int length = clob.length() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)clob.length();
            return clob.getSubString(1L, length);
        }
        UStatement uStatement2 = this.u_stmt;
        synchronized (uStatement2) {
            value = this.u_stmt.getString(index);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int index) throws SQLException {
        boolean value;
        this.checkIsOpen();
        this.beforeGetValue(index);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getBoolean(index);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int index) throws SQLException {
        byte value;
        this.checkIsOpen();
        this.beforeGetValue(index);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getByte(index);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int index) throws SQLException {
        short value;
        this.checkIsOpen();
        this.beforeGetValue(index);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getShort(index);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int index) throws SQLException {
        long value;
        this.checkIsOpen();
        this.beforeGetValue(index);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getLong(index);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int index) throws SQLException {
        float value;
        this.checkIsOpen();
        this.beforeGetValue(index);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getFloat(index);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int index) throws SQLException {
        double value;
        this.checkIsOpen();
        this.beforeGetValue(index);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getDouble(index);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int index) throws SQLException {
        byte[] value;
        Object obj;
        this.checkIsOpen();
        this.beforeGetValue(index);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            obj = this.u_stmt.getObject(index);
            this.error = this.u_stmt.getRecentError();
        }
        if (obj != null && obj instanceof Blob) {
            Blob blob = (Blob)obj;
            int length = blob.length() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)blob.length();
            return blob.getBytes(1L, length);
        }
        UStatement uStatement2 = this.u_stmt;
        synchronized (uStatement2) {
            value = this.u_stmt.getBytes(index);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int index) throws SQLException {
        Date value;
        this.checkIsOpen();
        this.beforeGetValue(index);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getDate(index);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int index) throws SQLException {
        Time value;
        this.checkIsOpen();
        this.beforeGetValue(index);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getTime(index);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int index) throws SQLException {
        Timestamp value;
        this.checkIsOpen();
        this.beforeGetValue(index);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getTimestamp(index);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int index) throws SQLException {
        Object value;
        this.checkIsOpen();
        this.beforeGetValue(index);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getObject(index);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int index) throws SQLException {
        BigDecimal value;
        this.checkIsOpen();
        this.beforeGetValue(index);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getBigDecimal(index);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    @Override
    public BigDecimal getBigDecimal(int index, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int index) throws SQLException {
        CUBRIDBlob value;
        this.checkIsOpen();
        this.beforeGetValue(index);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getBlob(index);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int index) throws SQLException {
        CUBRIDClob value;
        this.checkIsOpen();
        this.beforeGetValue(index);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getClob(index);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(int index, Calendar cal) throws SQLException {
        return this.getDate(index);
    }

    @Override
    public Time getTime(int index, Calendar cal) throws SQLException {
        return this.getTime(index);
    }

    @Override
    public Timestamp getTimestamp(int index, Calendar cal) throws SQLException {
        return this.getTimestamp(index);
    }

    @Override
    public URL getURL(int index) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setURL(String pName, URL val) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNull(String pName, int sqlType) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBoolean(String pName, boolean x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setByte(String pName, byte x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setShort(String pName, short x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInt(String pName, int x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLong(String pName, long x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFloat(String pName, float x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDouble(String pName, double x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBigDecimal(String pName, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setString(String pName, String x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBytes(String pName, byte[] x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDate(String pName, Date x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTime(String pName, Time x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTimestamp(String pName, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsciiStream(String pName, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(String pName, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(String pName, Object x, int targetSqlType, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(String pName, Object x, int targetSqlType) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(String pName, Object x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharacterStream(String pName, Reader reader, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDate(String pName, Date x, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTime(String pName, Time x, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTimestamp(String pName, Timestamp x, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNull(String pName, int sqlType, String typeName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(String pName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getBoolean(String pName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte getByte(String pName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(String pName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(String pName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(String pName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloat(String pName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(String pName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getBytes(String pName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(String pName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Time getTime(String pName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timestamp getTimestamp(String pName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(String pName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(String pName, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getBigDecimal(String pName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(String pName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob getBlob(String pName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob getClob(String pName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array getArray(String pName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(String pName, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Time getTime(String pName, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timestamp getTimestamp(String pName, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getURL(String pName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerOutParameter(int index, int sqlType) throws SQLException {
        this.doRegisterOutParameter(index, sqlType);
    }

    @Override
    public void registerOutParameter(int index, int sqlType, int scale) throws SQLException {
        this.doRegisterOutParameter(index, sqlType);
    }

    @Override
    public void registerOutParameter(int index, int sqlType, String typeName) throws SQLException {
        this.doRegisterOutParameter(index, sqlType);
    }

    @Override
    public void registerOutParameter(String pName, int sqlType) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerOutParameter(String pName, int sqlType, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerOutParameter(String pName, int sqlType, String typeName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRegisterOutParameter(int index, int sqlType) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.registerOutParameter(index - 1, sqlType);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeGetValue(int index) throws SQLException {
        if (index < 0 || index > this.u_stmt.getParameterCount()) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_index, null);
        }
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.fetch();
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.con.createCUBRIDException(this.error);
            }
        }
    }

    void checkGetXXXError() throws SQLException {
        switch (this.error.getErrorCode()) {
            case 0: {
                this.was_null = false;
                break;
            }
            case -21008: {
                this.was_null = true;
                break;
            }
            default: {
                throw this.con.createCUBRIDException(this.error);
            }
        }
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

