/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDDriver;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDJdbcInfoTable;
import cubrid.jdbc.driver.CUBRIDXid;
import cubrid.jdbc.driver.ConnectionProperties;
import cubrid.jdbc.jci.UAParameter;
import cubrid.jdbc.jci.UBatchResult;
import cubrid.jdbc.jci.UBindParameter;
import cubrid.jdbc.jci.UError;
import cubrid.jdbc.jci.UInputBuffer;
import cubrid.jdbc.jci.UJCIManager;
import cubrid.jdbc.jci.UJCIUtil;
import cubrid.jdbc.jci.UJciException;
import cubrid.jdbc.jci.UOutputBuffer;
import cubrid.jdbc.jci.UPutByOIDParameter;
import cubrid.jdbc.jci.UShardInfo;
import cubrid.jdbc.jci.UStatement;
import cubrid.jdbc.jci.UTimedDataInputStream;
import cubrid.jdbc.jci.UUrlCache;
import cubrid.jdbc.jci.UUrlHostKey;
import cubrid.jdbc.log.BasicLogger;
import cubrid.jdbc.log.Log;
import cubrid.jdbc.net.BrokerHandler;
import cubrid.sql.CUBRIDOID;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.transaction.xa.Xid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UConnection {
    public static final byte DBMS_CUBRID = 1;
    public static final byte DBMS_MYSQL = 2;
    public static final byte DBMS_ORACLE = 3;
    public static final byte DBMS_PROXY_CUBRID = 4;
    public static final byte DBMS_PROXY_MYSQL = 5;
    public static final byte DBMS_PROXY_ORACLE = 6;
    public static final byte PREPARE_INCLUDE_OID = 1;
    public static final byte PREPARE_UPDATABLE = 2;
    public static final byte PREPARE_QUERY_INFO = 4;
    public static final byte PREPARE_HOLDABLE = 8;
    public static final byte PREPARE_CALL = 64;
    public static final byte DROP_BY_OID = 1;
    public static final byte IS_INSTANCE = 2;
    public static final byte GET_READ_LOCK_BY_OID = 3;
    public static final byte GET_WRITE_LOCK_BY_OID = 4;
    public static final byte GET_CLASS_NAME_BY_OID = 5;
    public static final int OID_BYTE_SIZE = 8;
    private static final String magicString = "CUBRK";
    private static final byte CAS_CLIENT_JDBC = 3;
    public static final int PROTOCOL_V0 = 0;
    public static final int PROTOCOL_V1 = 1;
    public static final int PROTOCOL_V2 = 2;
    public static final int PROTOCOL_V3 = 3;
    public static final int PROTOCOL_V4 = 4;
    public static final int PROTOCOL_V5 = 5;
    public static final int PROTOCOL_V6 = 6;
    private static final byte CAS_PROTOCOL_VERSION = 6;
    private static final byte CAS_PROTO_INDICATOR = 64;
    private static final byte CAS_PROTO_VER_MASK = 63;
    private static final byte CAS_RENEWED_ERROR_CODE = -128;
    private static final byte CAS_SUPPORT_HOLDABLE_RESULT = 64;
    private static final byte CAS_RECONNECT_WHEN_SERVER_DOWN = 32;
    private static final byte GET_COLLECTION_VALUE = 1;
    private static final byte GET_SIZE_OF_COLLECTION = 2;
    private static final byte DROP_ELEMENT_IN_SET = 3;
    private static final byte ADD_ELEMENT_TO_SET = 4;
    private static final byte DROP_ELEMENT_IN_SEQUENCE = 5;
    private static final byte INSERT_ELEMENT_INTO_SEQUENCE = 6;
    private static final byte PUT_ELEMENT_ON_SEQUENCE = 7;
    private static final int DB_PARAM_ISOLATION_LEVEL = 1;
    private static final int DB_PARAM_LOCK_TIMEOUT = 2;
    private static final int DB_PARAM_AUTO_COMMIT = 4;
    private static final byte END_TRAN_COMMIT = 1;
    private static final byte END_TRAN_ROLLBACK = 2;
    private static final int LOCK_TIMEOUT_NOT_USED = -2;
    private static final int LOCK_TIMEOUT_INFINITE = -1;
    private static final int SOCKET_TIMEOUT = 5000;
    private static final int DRIVER_VERSION_MAX_SIZE = 20;
    private static final byte CAS_INFO_STATUS_INACTIVE = 0;
    private static final byte CAS_INFO_STATUS_ACTIVE = 1;
    private static final int CAS_INFO_SIZE = 4;
    private static final int CAS_INFO_STATUS = 0;
    private static final int CAS_INFO_RESERVED_1 = 1;
    private static final int CAS_INFO_RESERVED_2 = 2;
    private static final int CAS_INFO_ADDITIONAL_FLAG = 3;
    private static final byte CAS_INFO_FLAG_MASK_AUTOCOMMIT = 1;
    private static final byte CAS_INFO_FLAG_MASK_FORCE_OUT_TRAN = 2;
    private static final byte CAS_INFO_FLAG_MASK_NEW_SESSION_ID = 4;
    private static final int BROKER_INFO_SIZE = 8;
    private static final int BROKER_INFO_DBMS_TYPE = 0;
    private static final int BROKER_INFO_RESERVED4 = 1;
    private static final int BROKER_INFO_STATEMENT_POOLING = 2;
    private static final int BROKER_INFO_CCI_PCONNECT = 3;
    private static final int BROKER_INFO_PROTO_VERSION = 4;
    private static final int BROKER_INFO_FUNCTION_FLAG = 5;
    private static final int BROKER_INFO_RESERVED2 = 6;
    private static final int BROKER_INFO_RESERVED3 = 7;
    private static final int BROKER_INFO_MAJOR_VERSION = 4;
    private static final int BROKER_INFO_MINOR_VERSION = 5;
    private static final int BROKER_INFO_PATCH_VERSION = 6;
    public static final String ZERO_DATETIME_BEHAVIOR_CONVERT_TO_NULL = "convertToNull";
    public static final String ZERO_DATETIME_BEHAVIOR_EXCEPTION = "exception";
    public static final String ZERO_DATETIME_BEHAVIOR_ROUND = "round";
    public static final int SESSION_ID_SIZE = 20;
    public static final int MAX_QUERY_TIMEOUT = 2000000;
    public static final int MAX_CONNECT_TIMEOUT = 2000000;
    UOutputBuffer outBuffer;
    CUBRIDConnection cubridcon;
    boolean update_executed;
    private boolean needReconnection;
    private UTimedDataInputStream input;
    private DataOutputStream output;
    public String CASIp = "";
    public int CASPort;
    public int processId;
    public int casId;
    private Socket client;
    private UError errorHandler;
    private boolean isClosed = false;
    private byte[] dbInfo;
    private int lastIsolationLevel;
    private int lastLockTimeout = -2;
    private boolean lastAutoCommit = true;
    String dbname = "";
    String user = "";
    String passwd = "";
    String url = null;
    private ArrayList<String> altHosts = null;
    private int connectedHostId = 0;
    private byte[] broker_info = null;
    private byte[] casinfo = null;
    private int brokerVersion = 0;
    private boolean isServerSideJdbc = false;
    boolean skip_checkcas = false;
    Vector<UStatement> pooled_ustmts;
    Vector<Integer> deferred_close_handle;
    Object curThread;
    private UUrlCache url_cache = null;
    private boolean isAutoCommitBySelf = false;
    public static byte[] driverInfo = new byte[10];
    private ConnectionProperties connectionProperties = new ConnectionProperties();
    private long lastFailureTime = 0L;
    byte[] sessionId = this.createNullSession();
    int oldSessionId = 0;
    private Log log;
    private long beginTime;
    private int lastShardId = -1;
    private int numShard = 0;
    UShardInfo[] shardInfo = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    UConnection(String ip, int port, String dbname, String user, String passwd, String url) throws CUBRIDException {
        if (ip != null) {
            this.CASIp = ip;
        }
        this.CASPort = port;
        if (dbname != null) {
            this.dbname = dbname;
        }
        if (user != null) {
            this.user = user;
        }
        if (passwd != null) {
            this.passwd = passwd;
        }
        this.url = url;
        this.update_executed = false;
        this.needReconnection = true;
        this.errorHandler = new UError(this);
    }

    UConnection(ArrayList<String> altHostList, String dbname, String user, String passwd, String url) throws CUBRIDException {
        this.setAltHosts(altHostList);
        if (dbname != null) {
            this.dbname = dbname;
        }
        if (user != null) {
            this.user = user;
        }
        if (passwd != null) {
            this.passwd = passwd;
        }
        this.url = url;
        this.update_executed = false;
        this.needReconnection = true;
        this.errorHandler = new UError(this);
    }

    UConnection(Socket socket, Object curThread) throws CUBRIDException {
        this.errorHandler = new UError(this);
        try {
            this.client = socket;
            this.client.setTcpNoDelay(true);
            this.output = new DataOutputStream(this.client.getOutputStream());
            this.output.writeInt(8);
            this.output.flush();
            this.input = new UTimedDataInputStream(this.client.getInputStream(), this.CASIp, this.CASPort);
            this.needReconnection = false;
            this.casinfo = new byte[4];
            this.casinfo[0] = 1;
            this.casinfo[1] = 0;
            this.casinfo[2] = 0;
            this.casinfo[3] = 0;
            this.broker_info = new byte[8];
            this.broker_info[0] = 1;
            this.broker_info[1] = 0;
            this.broker_info[2] = 1;
            this.broker_info[3] = 0;
            this.broker_info[4] = 70;
            this.broker_info[5] = -64;
            this.broker_info[6] = 0;
            this.broker_info[7] = 0;
            this.brokerVersion = this.makeProtoVersion(6);
            this.isServerSideJdbc = true;
            this.lastAutoCommit = false;
            this.curThread = curThread;
            UJCIUtil.invoke("com.cubrid.jsp.ExecuteThread", "setCharSet", new Class[]{String.class}, this.curThread, new Object[]{this.connectionProperties.getCharSet()});
        }
        catch (IOException e) {
            UJciException je = new UJciException(-21013);
            je.toUError(this.errorHandler);
            throw new CUBRIDException(this.errorHandler, (Throwable)e);
        }
    }

    public void tryConnect() throws CUBRIDException {
        try {
            if (this.connectionProperties.getUseLazyConnection()) {
                this.needReconnection = true;
                return;
            }
            this.setBeginTime();
            this.checkReconnect();
            this.endTransaction(true);
        }
        catch (UJciException e) {
            this.clientSocketClose();
            e.toUError(this.errorHandler);
            throw new CUBRIDException(this.errorHandler, (Throwable)e);
        }
        catch (IOException e) {
            this.clientSocketClose();
            if (e instanceof SocketTimeoutException) {
                throw new CUBRIDException(CUBRIDJDBCErrorCode.request_timeout, (Throwable)e);
            }
            throw new CUBRIDException(CUBRIDJDBCErrorCode.ioexception_in_stream, (Throwable)e);
        }
    }

    public void setAltHosts(ArrayList<String> altHostList) throws CUBRIDException {
        if (altHostList.size() < 1) {
            throw new CUBRIDException(-21016);
        }
        this.altHosts = altHostList;
        String hostPort = this.altHosts.get(0);
        int pos = hostPort.indexOf(58);
        this.CASIp = pos < 0 ? hostPort.substring(0) : hostPort.substring(0, pos);
        this.CASPort = pos > 0 ? Integer.valueOf(hostPort.substring(pos + 1)) : 30000;
    }

    public int getQueryTimeout() {
        return this.connectionProperties.getQueryTimeout();
    }

    public void setCharset(String newCharsetName) {
        if (UJCIUtil.isServerSide() && this.isServerSideJdbc) {
            UJCIUtil.invoke("com.cubrid.jsp.ExecuteThread", "setCharSet", new Class[]{String.class}, this.curThread, new Object[]{newCharsetName});
        }
    }

    public String getCharset() {
        return this.connectionProperties.getCharSet();
    }

    public void setZeroDateTimeBehavior(String behavior) throws CUBRIDException {
        if (UJCIUtil.isServerSide() && this.isServerSideJdbc) {
            UJCIUtil.invoke("com.cubrid.jsp.ExecuteThread", "setZeroDateTimeBehavior", new Class[]{String.class}, this.curThread, new Object[]{behavior});
        }
    }

    public String getZeroDateTimeBehavior() {
        return this.connectionProperties.getZeroDateTimeBehavior();
    }

    public boolean getLogSlowQuery() {
        return this.connectionProperties.getLogSlowQueris();
    }

    public synchronized void addElementToSet(CUBRIDOID oid, String attributeName, Object value) {
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return;
        }
        try {
            this.manageElementOfSet(oid, attributeName, value, (byte)4);
        }
        catch (UJciException e) {
            this.logException(e);
            e.toUError(this.errorHandler);
            return;
        }
        catch (IOException e) {
            this.logException(e);
            this.errorHandler.setErrorCode(-21003);
            return;
        }
    }

    public synchronized UBatchResult batchExecute(String[] batchSqlStmt, int queryTimeout) {
        this.errorHandler = new UError(this);
        this.setShardId(-1);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return null;
        }
        if (batchSqlStmt == null) {
            this.errorHandler.setErrorCode(-21016);
            return null;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return null;
            }
            this.outBuffer.newRequest(this.output, (byte)20);
            this.outBuffer.addByte(this.getAutoCommit() ? (byte)1 : 0);
            if (this.protoVersionIsAbove(4)) {
                long remainingTime = this.getRemainingTime(queryTimeout * 1000);
                if (queryTimeout > 0 && remainingTime <= 0L) {
                    throw this.createJciException(-21024);
                }
                this.outBuffer.addInt((int)remainingTime);
            }
            for (int i = 0; i < batchSqlStmt.length; ++i) {
                if (batchSqlStmt[i] != null) {
                    this.outBuffer.addStringWithNull(batchSqlStmt[i]);
                    continue;
                }
                this.outBuffer.addNull();
            }
            UInputBuffer inBuffer = this.send_recv_msg();
            UBatchResult batchResult = new UBatchResult(inBuffer.readInt());
            for (int i = 0; i < batchResult.getResultNumber(); ++i) {
                batchResult.setStatementType(i, inBuffer.readByte());
                int result = inBuffer.readInt();
                if (result < 0) {
                    int err_code = inBuffer.readInt();
                    batchResult.setResultError(i, err_code, inBuffer.readString(inBuffer.readInt(), UJCIManager.sysCharsetName));
                    continue;
                }
                batchResult.setResult(i, result);
                inBuffer.readInt();
                inBuffer.readShort();
                inBuffer.readShort();
            }
            if (this.protoVersionIsAbove(5)) {
                this.setShardId(inBuffer.readInt());
            }
            this.update_executed = true;
            return batchResult;
        }
        catch (UJciException e) {
            this.logException(e);
            e.toUError(this.errorHandler);
        }
        catch (IOException e) {
            this.logException(e);
            this.errorHandler.setErrorCode(-21003);
        }
        return null;
    }

    public synchronized void close() {
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return;
        }
        if (this.client != null) {
            this.disconnect();
        }
        if (!this.isServerSideJdbc && this.client != null) {
            this.clientSocketClose();
        }
        this.isClosed = true;
    }

    public synchronized void dropElementInSequence(CUBRIDOID oid, String attributeName, int index) {
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return;
        }
        try {
            this.setBeginTime();
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return;
            }
            this.outBuffer.newRequest(this.output, (byte)18);
            this.outBuffer.addByte((byte)5);
            this.outBuffer.addOID(oid);
            this.outBuffer.addInt(index);
            if (attributeName == null) {
                this.outBuffer.addNull();
            } else {
                this.outBuffer.addStringWithNull(attributeName);
            }
            this.send_recv_msg();
        }
        catch (UJciException e) {
            this.logException(e);
            e.toUError(this.errorHandler);
        }
        catch (IOException e) {
            this.logException(e);
            this.errorHandler.setErrorCode(-21003);
        }
    }

    public synchronized void dropElementInSet(CUBRIDOID oid, String attributeName, Object value) {
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return;
        }
        try {
            this.manageElementOfSet(oid, attributeName, value, (byte)3);
        }
        catch (UJciException e) {
            this.logException(e);
            e.toUError(this.errorHandler);
            return;
        }
        catch (IOException e) {
            this.logException(e);
            this.errorHandler.setErrorCode(-21003);
            return;
        }
    }

    public synchronized void endTransaction(boolean type) {
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return;
        }
        if (this.needReconnection) {
            return;
        }
        try {
            if (this.client != null && this.getCASInfoStatus() != 0) {
                this.setBeginTime();
                this.checkReconnect();
                if (this.errorHandler.getErrorCode() != 0) {
                    return;
                }
                if (this.getCASInfoStatus() == 1) {
                    if (UJCIUtil.isConsoleDebug() && this.lastAutoCommit && !this.isAutoCommitBySelf && type) {
                        throw new Exception("Check It Out!");
                    }
                    this.outBuffer.newRequest(this.output, (byte)1);
                    this.outBuffer.addByte(type ? (byte)1 : 2);
                    this.send_recv_msg();
                    if (this.lastAutoCommit) {
                        this.turnOffAutoCommitBySelf();
                    }
                }
            }
        }
        catch (UJciException e) {
            this.logException(e);
            e.toUError(this.errorHandler);
        }
        catch (IOException e) {
            this.logException(e);
            this.errorHandler.setErrorCode(-21003);
        }
        catch (Exception e) {
            this.logException(e);
            this.errorHandler.setErrorMessage(-21023, e.getMessage());
        }
        boolean keepConnection = true;
        long currentTime = System.currentTimeMillis() / 1000L;
        int reconnectTime = this.connectionProperties.getReconnectTime();
        if (this.connectedHostId > 0 && this.lastFailureTime != 0L && reconnectTime > 0 && currentTime - this.lastFailureTime > (long)reconnectTime && !CUBRIDDriver.unreachableHosts.contains(this.altHosts.get(0))) {
            keepConnection = false;
            this.lastFailureTime = 0L;
        }
        if (this.errorHandler.getErrorCode() != 0 || !keepConnection) {
            if (!type) {
                this.errorHandler.clear();
            }
            this.clientSocketClose();
            this.needReconnection = true;
        }
        this.casinfo[0] = 0;
        this.update_executed = false;
    }

    public synchronized OutputStream getOutputStream() {
        return this.output;
    }

    public synchronized UStatement getByOID(CUBRIDOID oid, String[] attributeName) {
        UStatement returnValue = null;
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return null;
        }
        try {
            this.setBeginTime();
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return null;
            }
            this.outBuffer.newRequest(this.output, (byte)10);
            this.outBuffer.addOID(oid);
            for (int i = 0; attributeName != null && i < attributeName.length; ++i) {
                if (attributeName[i] != null) {
                    this.outBuffer.addStringWithNull(attributeName[i]);
                    continue;
                }
                this.outBuffer.addNull();
            }
            UInputBuffer inBuffer = this.send_recv_msg();
            returnValue = new UStatement(this, oid, attributeName, inBuffer);
        }
        catch (UJciException e) {
            this.logException(e);
            e.toUError(this.errorHandler);
            return null;
        }
        catch (IOException e) {
            this.logException(e);
            this.errorHandler.setErrorCode(-21003);
            return null;
        }
        if (returnValue.getRecentError().getErrorCode() != 0) {
            this.errorHandler.copyValue(returnValue.getRecentError());
            return null;
        }
        return returnValue;
    }

    public synchronized String getDatabaseProductVersion() {
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return null;
        }
        try {
            this.setBeginTime();
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return null;
            }
            this.outBuffer.newRequest(this.output, (byte)15);
            this.outBuffer.addByte(this.getAutoCommit() ? (byte)1 : 0);
            UInputBuffer inBuffer = this.send_recv_msg();
            return inBuffer.readString(inBuffer.remainedCapacity(), UJCIManager.sysCharsetName);
        }
        catch (UJciException e) {
            this.logException(e);
            e.toUError(this.errorHandler);
        }
        catch (IOException e) {
            this.logException(e);
            this.errorHandler.setErrorCode(-21003);
        }
        return null;
    }

    public synchronized int getIsolationLevel() {
        this.errorHandler = new UError(this);
        if (this.lastIsolationLevel != 0) {
            return this.lastIsolationLevel;
        }
        if (UJCIUtil.isMMDB()) {
            this.lastIsolationLevel = 1;
            return this.lastIsolationLevel;
        }
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return 0;
        }
        try {
            this.setBeginTime();
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return 0;
            }
            this.outBuffer.newRequest(this.output, (byte)4);
            this.outBuffer.addInt(1);
            UInputBuffer inBuffer = this.send_recv_msg();
            this.lastIsolationLevel = inBuffer.readInt();
            return this.lastIsolationLevel;
        }
        catch (UJciException e) {
            this.logException(e);
            e.toUError(this.errorHandler);
        }
        catch (IOException e) {
            this.logException(e);
            this.errorHandler.setErrorCode(-21003);
        }
        return 0;
    }

    public UError getRecentError() {
        return this.errorHandler;
    }

    public synchronized String getQueryplanOnly(String sql) {
        String ret_val;
        if (sql == null) {
            return null;
        }
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return null;
        }
        try {
            this.setBeginTime();
            this.checkReconnect();
            this.outBuffer.newRequest((byte)24);
            this.outBuffer.addInt(0);
            this.outBuffer.addByte((byte)1);
            this.outBuffer.addStringWithNull(sql);
            UInputBuffer inBuffer = this.send_recv_msg();
            ret_val = inBuffer.readString(inBuffer.remainedCapacity(), this.connectionProperties.getCharSet());
        }
        catch (UJciException e) {
            this.logException(e);
            e.toUError(this.errorHandler);
            return null;
        }
        catch (IOException e) {
            this.logException(e);
            if (this.errorHandler.getErrorCode() != -21013) {
                this.errorHandler.setErrorCode(-21003);
            }
            return null;
        }
        if (this.errorHandler.getErrorCode() != 0) {
            return null;
        }
        return ret_val;
    }

    public synchronized UStatement getSchemaInfo(int type, String arg1, String arg2, byte flag, int shard_id) {
        UStatement returnValue = null;
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return null;
        }
        if (type < 1 || type > 19) {
            this.errorHandler.setErrorCode(-21011);
            return null;
        }
        if (flag < 0 || flag > 3) {
            this.errorHandler.setErrorCode(-21018);
            return null;
        }
        try {
            this.setBeginTime();
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return null;
            }
            this.outBuffer.newRequest(this.output, (byte)9);
            this.outBuffer.addInt(type);
            if (arg1 == null) {
                this.outBuffer.addNull();
            } else {
                this.outBuffer.addStringWithNull(arg1);
            }
            if (arg2 == null) {
                this.outBuffer.addNull();
            } else {
                this.outBuffer.addStringWithNull(arg2);
            }
            this.outBuffer.addByte(flag);
            if (this.protoVersionIsAbove(5)) {
                this.outBuffer.addInt(shard_id);
            }
            UInputBuffer inBuffer = this.send_recv_msg();
            returnValue = new UStatement(this, arg1, arg2, type, inBuffer);
        }
        catch (UJciException e) {
            this.logException(e);
            e.toUError(this.errorHandler);
            return null;
        }
        catch (IOException e) {
            this.logException(e);
            if (this.errorHandler.getErrorCode() != -21013) {
                this.errorHandler.setErrorCode(-21003);
            }
            return null;
        }
        if (returnValue.getRecentError().getErrorCode() != 0) {
            this.errorHandler.copyValue(returnValue.getRecentError());
            return null;
        }
        return returnValue;
    }

    public synchronized int getSizeOfCollection(CUBRIDOID oid, String attributeName) {
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return 0;
        }
        try {
            this.setBeginTime();
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return 0;
            }
            this.outBuffer.newRequest(this.output, (byte)18);
            this.outBuffer.addByte((byte)2);
            this.outBuffer.addOID(oid);
            if (attributeName == null) {
                this.outBuffer.addNull();
            } else {
                this.outBuffer.addStringWithNull(attributeName);
            }
            UInputBuffer inBuffer = this.send_recv_msg();
            return inBuffer.readInt();
        }
        catch (UJciException e) {
            this.logException(e);
            e.toUError(this.errorHandler);
        }
        catch (IOException e) {
            this.logException(e);
            this.errorHandler.setErrorCode(-21003);
        }
        return 0;
    }

    public synchronized void insertElementIntoSequence(CUBRIDOID oid, String attributeName, int index, Object value) {
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return;
        }
        try {
            this.manageElementOfSequence(oid, attributeName, index, value, (byte)6);
        }
        catch (UJciException e) {
            this.logException(e);
            e.toUError(this.errorHandler);
            return;
        }
        catch (IOException e) {
            this.logException(e);
            if (this.errorHandler.getErrorCode() != -21013) {
                this.errorHandler.setErrorCode(-21003);
            }
            return;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isErrorCommunication(int error) {
        switch (error) {
            case -21019: 
            case -21003: 
            case -10003: {
                return true;
            }
        }
        return false;
    }

    public boolean isErrorToReconnect(int error) {
        if (this.isErrorCommunication(error)) {
            return true;
        }
        switch (error) {
            case -677: 
            case -224: 
            case -199: 
            case -111: {
                return true;
            }
        }
        return false;
    }

    private UStatement prepareInternal(String sql, byte flag, boolean recompile) throws IOException, UJciException {
        this.errorHandler.clear();
        this.outBuffer.newRequest(this.output, (byte)2);
        this.outBuffer.addStringWithNull(sql);
        this.outBuffer.addByte(flag);
        this.outBuffer.addByte(this.getAutoCommit() ? (byte)1 : 0);
        while (!this.deferred_close_handle.isEmpty()) {
            Integer close_handle = this.deferred_close_handle.remove(0);
            this.outBuffer.addInt(close_handle);
        }
        UInputBuffer inBuffer = this.send_recv_msg();
        UStatement stmt = recompile ? new UStatement(this, inBuffer, true, sql, flag) : new UStatement(this, inBuffer, false, sql, flag);
        if (stmt.getRecentError().getErrorCode() != 0) {
            this.errorHandler.copyValue(stmt.getRecentError());
            return null;
        }
        this.pooled_ustmts.add(stmt);
        return stmt;
    }

    public synchronized UStatement prepare(String sql, byte flag) {
        return this.prepare(sql, flag, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized UStatement prepare(String sql, byte flag, boolean recompile) {
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return null;
        }
        UStatement stmt = null;
        boolean isFirstPrepareInTran = !this.isActive();
        this.skip_checkcas = true;
        try {
            this.checkReconnect();
            UStatement uStatement = stmt = this.prepareInternal(sql, flag, recompile);
            return uStatement;
        }
        catch (UJciException e) {
            this.logException(e);
            e.toUError(this.errorHandler);
        }
        catch (IOException e) {
            this.logException(e);
            this.errorHandler.setErrorCode(-21003);
            this.errorHandler.setStackTrace(e.getStackTrace());
        }
        finally {
            this.skip_checkcas = false;
        }
        if (this.isActive() && !isFirstPrepareInTran) {
            return null;
        }
        while (this.isErrorToReconnect(this.errorHandler.getJdbcErrorCode())) {
            if (!this.brokerInfoReconnectWhenServerDown() || this.isErrorCommunication(this.errorHandler.getJdbcErrorCode())) {
                this.clientSocketClose();
            }
            try {
                this.errorHandler.clear();
                this.checkReconnect();
                if (this.errorHandler.getErrorCode() != 0) {
                    return null;
                }
            }
            catch (UJciException e) {
                this.logException(e);
                e.toUError(this.errorHandler);
                return null;
            }
            catch (IOException e) {
                this.logException(e);
                this.errorHandler.setErrorCode(-21003);
                this.errorHandler.setStackTrace(e.getStackTrace());
                return null;
            }
            try {
                stmt = this.prepareInternal(sql, flag, recompile);
                return stmt;
            }
            catch (UJciException e) {
                this.logException(e);
                e.toUError(this.errorHandler);
            }
            catch (IOException e) {
                this.logException(e);
                this.errorHandler.setErrorCode(-21003);
                this.errorHandler.setStackTrace(e.getStackTrace());
            }
        }
        return null;
    }

    public synchronized void putByOID(CUBRIDOID oid, String[] attributeName, Object[] values) {
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return;
        }
        if (attributeName == null && values == null) {
            this.errorHandler.setErrorCode(-21016);
            return;
        }
        try {
            UPutByOIDParameter putParameter = null;
            if (values != null) {
                putParameter = new UPutByOIDParameter(attributeName, values);
            }
            this.setBeginTime();
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return;
            }
            this.outBuffer.newRequest(this.output, (byte)11);
            this.outBuffer.addOID(oid);
            if (putParameter != null) {
                putParameter.writeParameter(this.outBuffer);
            }
            this.send_recv_msg();
            if (this.getAutoCommit()) {
                this.turnOnAutoCommitBySelf();
            }
        }
        catch (UJciException e) {
            this.logException(e);
            e.toUError(this.errorHandler);
        }
        catch (IOException e) {
            this.logException(e);
            this.errorHandler.setErrorCode(-21003);
        }
    }

    public synchronized void putElementInSequence(CUBRIDOID oid, String attributeName, int index, Object value) {
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return;
        }
        try {
            this.manageElementOfSequence(oid, attributeName, index, value, (byte)7);
        }
        catch (UJciException e) {
            this.logException(e);
            e.toUError(this.errorHandler);
            return;
        }
        catch (IOException e) {
            this.logException(e);
            if (this.errorHandler.getErrorCode() != -21013) {
                this.errorHandler.setErrorCode(-21003);
            }
            return;
        }
    }

    public synchronized void setIsolationLevel(int level) {
        this.errorHandler = new UError(this);
        if (this.lastIsolationLevel != 0 && this.lastIsolationLevel == level) {
            return;
        }
        if (!UJCIUtil.isMMDB()) {
            if (this.isClosed) {
                this.errorHandler.setErrorCode(-21017);
                return;
            }
            if (level < 1 || level > 6) {
                this.errorHandler.setErrorCode(-21014);
                return;
            }
            try {
                this.setBeginTime();
                this.checkReconnect();
                if (this.errorHandler.getErrorCode() != 0) {
                    return;
                }
                this.outBuffer.newRequest(this.output, (byte)5);
                this.outBuffer.addInt(1);
                this.outBuffer.addInt(level);
                this.send_recv_msg();
                this.lastIsolationLevel = level;
            }
            catch (UJciException e) {
                this.logException(e);
                e.toUError(this.errorHandler);
            }
            catch (IOException e) {
                this.logException(e);
                this.errorHandler.setErrorCode(-21003);
            }
        }
    }

    public synchronized void setLockTimeout(int timeout) {
        this.errorHandler = new UError(this);
        if (this.lastLockTimeout != -2 && this.lastLockTimeout == timeout) {
            return;
        }
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return;
        }
        try {
            this.setBeginTime();
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return;
            }
            this.outBuffer.newRequest(this.output, (byte)5);
            this.outBuffer.addInt(2);
            this.outBuffer.addInt(timeout);
            this.send_recv_msg();
            this.lastLockTimeout = timeout < 0 ? -1 : timeout;
        }
        catch (UJciException e) {
            this.logException(e);
            e.toUError(this.errorHandler);
        }
        catch (IOException e) {
            this.logException(e);
            this.errorHandler.setErrorCode(-21003);
        }
    }

    public synchronized int setCASChangeMode(int mode) {
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return this.errorHandler.getJdbcErrorCode();
        }
        try {
            this.setBeginTime();
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return this.errorHandler.getJdbcErrorCode();
            }
            this.outBuffer.newRequest(this.output, (byte)44);
            this.outBuffer.addInt(mode);
            UInputBuffer inBuffer = this.send_recv_msg();
            return inBuffer.readInt();
        }
        catch (UJciException e) {
            this.logException(e);
            e.toUError(this.errorHandler);
        }
        catch (IOException e) {
            this.logException(e);
            this.errorHandler.setErrorCode(-21003);
        }
        return this.errorHandler.getJdbcErrorCode();
    }

    public byte getCASInfoStatus() {
        if (this.casinfo == null) {
            return 0;
        }
        return this.casinfo[0];
    }

    public byte[] getCASInfo() {
        return this.casinfo;
    }

    public void setCASInfo(byte[] casinfo) {
        this.casinfo = casinfo;
    }

    public byte getDbmsType() {
        if (this.broker_info == null) {
            return 1;
        }
        return this.broker_info[0];
    }

    public boolean isConnectedToCubrid() {
        byte dbms_type = this.getDbmsType();
        return dbms_type == 1 || dbms_type == 4;
    }

    public boolean isConnectedToOracle() {
        byte dbms_type = this.getDbmsType();
        return dbms_type == 3 || dbms_type == 6;
    }

    public boolean isConnectedToProxy() {
        byte dbms_type = this.getDbmsType();
        return dbms_type == 4 || dbms_type == 5 || dbms_type == 6;
    }

    public boolean brokerInfoStatementPooling() {
        if (this.broker_info == null) {
            return false;
        }
        return this.broker_info[2] == 1;
    }

    public boolean brokerInfoRenewedErrorCode() {
        if ((this.broker_info[4] & 0x40) != 64) {
            return false;
        }
        return (this.broker_info[5] & 0xFFFFFF80) == -128;
    }

    public boolean brokerInfoSupportHoldableResult() {
        if (this.broker_info == null) {
            return false;
        }
        return (this.broker_info[5] & 0x40) == 64;
    }

    public boolean brokerInfoReconnectWhenServerDown() {
        if (this.broker_info == null) {
            return false;
        }
        return (this.broker_info[5] & 0x20) == 32;
    }

    public boolean supportHoldableResult() {
        return this.brokerInfoSupportHoldableResult() || this.protoVersionIsSame(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void xa_endTransaction(Xid xid, boolean type) {
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return;
        }
        try {
            this.setBeginTime();
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return;
            }
            this.outBuffer.newRequest(this.output, (byte)30);
            this.outBuffer.addXid(xid);
            this.outBuffer.addByte(type ? (byte)1 : 2);
            this.send_recv_msg();
        }
        catch (Exception e) {
            this.errorHandler.setErrorCode(-21023);
        }
        finally {
            this.clientSocketClose();
            this.needReconnection = true;
        }
    }

    public synchronized void xa_prepare(Xid xid) {
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return;
        }
        try {
            this.setBeginTime();
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return;
            }
            this.outBuffer.newRequest(this.output, (byte)28);
            this.outBuffer.addXid(xid);
            this.send_recv_msg();
        }
        catch (Exception e) {
            this.errorHandler.setErrorCode(-21023);
        }
    }

    public synchronized Xid[] xa_recover() {
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return null;
        }
        try {
            this.setBeginTime();
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return null;
            }
            this.outBuffer.newRequest(this.output, (byte)29);
            UInputBuffer inBuffer = this.send_recv_msg();
            int num_xid = inBuffer.getResCode();
            Xid[] xid = new CUBRIDXid[num_xid];
            for (int i = 0; i < num_xid; ++i) {
                xid[i] = inBuffer.readXid();
            }
            return xid;
        }
        catch (Exception e) {
            this.errorHandler.setErrorCode(-21023);
            return null;
        }
    }

    public void setCUBRIDConnection(CUBRIDConnection con) {
        this.cubridcon = con;
        this.lastIsolationLevel = 0;
        this.lastLockTimeout = -2;
    }

    public CUBRIDConnection getCUBRIDConnection() {
        return this.cubridcon;
    }

    private static void printCasInfo(byte[] prev, byte[] curr) {
        if (prev != null) {
            String fmt = "[PREV : %d, RECV : %d], [preffunc : %d, recvfunc : %d], [REQ: %d], [JID: %d]";
            String msg = String.format(fmt, prev[0], curr[0], prev[1], curr[1], prev[2], curr[3]);
            CUBRIDDriver.printDebug(msg);
        }
    }

    public synchronized boolean check_cas() {
        if (this.isClosed) {
            return true;
        }
        if (this.client == null || this.needReconnection) {
            return true;
        }
        if (this.skip_checkcas) {
            return true;
        }
        try {
            this.outBuffer.newRequest(this.output, (byte)32);
            this.send_recv_msg();
        }
        catch (IOException e) {
            this.logException(e);
            return false;
        }
        catch (UJciException e) {
            this.logException(e);
            return false;
        }
        return true;
    }

    public synchronized boolean check_cas(String msg) {
        try {
            this.outBuffer.newRequest(this.output, (byte)32);
            this.outBuffer.addStringWithNull(msg);
            this.send_recv_msg();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public synchronized void reset_connection() {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.client = null;
        this.needReconnection = true;
    }

    public synchronized Object oidCmd(CUBRIDOID oid, byte cmd) {
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return null;
        }
        try {
            this.setBeginTime();
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return null;
            }
            this.outBuffer.newRequest(this.output, (byte)17);
            this.outBuffer.addByte(cmd);
            this.outBuffer.addOID(oid);
            UInputBuffer inBuffer = this.send_recv_msg();
            int res_code = inBuffer.getResCode();
            if (cmd == 2) {
                if (res_code == 1) {
                    return oid;
                }
            } else if (cmd == 5) {
                return inBuffer.readString(inBuffer.remainedCapacity(), this.connectionProperties.getCharSet());
            }
        }
        catch (UJciException e) {
            this.logException(e);
            e.toUError(this.errorHandler);
        }
        catch (IOException e) {
            this.logException(e);
            this.errorHandler.setErrorCode(-21003);
        }
        return null;
    }

    public synchronized byte[] lobNew(int lob_type) {
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return null;
        }
        try {
            this.setBeginTime();
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return null;
            }
            this.outBuffer.newRequest(this.output, (byte)35);
            this.outBuffer.addInt(lob_type);
            UInputBuffer inBuffer = this.send_recv_msg();
            int res_code = inBuffer.getResCode();
            if (res_code < 0) {
                this.errorHandler.setErrorCode(-21023);
                return null;
            }
            byte[] packedLobHandle = new byte[res_code];
            inBuffer.readBytes(packedLobHandle);
            return packedLobHandle;
        }
        catch (UJciException e) {
            this.logException(e);
            e.toUError(this.errorHandler);
        }
        catch (IOException e) {
            this.logException(e);
            this.errorHandler.setErrorCode(-21003);
        }
        catch (Exception e) {
            this.logException(e);
            this.errorHandler.setErrorCode(-21023);
        }
        return null;
    }

    public synchronized int lobWrite(byte[] packedLobHandle, long offset, byte[] buf, int start, int len) {
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return -1;
        }
        try {
            this.setBeginTime();
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return -1;
            }
            this.outBuffer.newRequest(this.output, (byte)36);
            this.outBuffer.addBytes(packedLobHandle);
            this.outBuffer.addLong(offset);
            this.outBuffer.addBytes(buf, start, len);
            UInputBuffer inBuffer = this.send_recv_msg();
            int res_code = inBuffer.getResCode();
            if (res_code < 0) {
                this.errorHandler.setErrorCode(-21023);
            }
            return res_code;
        }
        catch (UJciException e) {
            this.logException(e);
            e.toUError(this.errorHandler);
        }
        catch (IOException e) {
            this.logException(e);
            this.errorHandler.setErrorCode(-21003);
        }
        catch (Exception e) {
            this.logException(e);
            this.errorHandler.setErrorCode(-21023);
        }
        return -1;
    }

    public synchronized int lobRead(byte[] packedLobHandle, long offset, byte[] buf, int start, int len) {
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return -1;
        }
        try {
            this.setBeginTime();
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return -1;
            }
            this.outBuffer.newRequest(this.output, (byte)37);
            this.outBuffer.addBytes(packedLobHandle);
            this.outBuffer.addLong(offset);
            this.outBuffer.addInt(len);
            UInputBuffer inBuffer = this.send_recv_msg();
            int res_code = inBuffer.getResCode();
            if (res_code < 0) {
                this.errorHandler.setErrorCode(-21023);
            } else {
                inBuffer.readBytes(buf, start, res_code);
            }
            return res_code;
        }
        catch (UJciException e) {
            this.logException(e);
            e.toUError(this.errorHandler);
        }
        catch (IOException e) {
            this.logException(e);
            this.errorHandler.setErrorCode(-21003);
        }
        catch (Exception e) {
            this.logException(e);
            this.errorHandler.setErrorCode(-21023);
        }
        return -1;
    }

    public synchronized void setAutoCommit(boolean autoCommit) {
        if (!this.isServerSideJdbc && this.lastAutoCommit != autoCommit) {
            this.lastAutoCommit = autoCommit;
        }
    }

    public boolean getAutoCommit() {
        return this.lastAutoCommit;
    }

    public int currentIsolationLevel() {
        return this.lastIsolationLevel;
    }

    public static byte[] createDBInfo(String dbname, String user, String passwd, String url) {
        byte[] info = new byte[628];
        UJCIUtil.copy_bytes(info, 0, 32, dbname);
        UJCIUtil.copy_bytes(info, 32, 32, user);
        UJCIUtil.copy_bytes(info, 64, 32, passwd);
        UJCIUtil.copy_bytes(info, 96, 511, url);
        if (url == null) {
            UJCIUtil.copy_byte(info, 96, (byte)0);
            UJCIUtil.copy_byte(info, 97, (byte)0);
        } else {
            String version = "9.3.9.0002";
            int index = 96 + url.getBytes().length + 1;
            if (version.getBytes().length <= 20 && url.getBytes().length + version.getBytes().length + 3 <= 512) {
                byte len = (byte)version.getBytes().length;
                UJCIUtil.copy_byte(info, index, len);
                UJCIUtil.copy_bytes(info, index + 1, version.getBytes().length + 1, version);
            } else {
                UJCIUtil.copy_byte(info, index, (byte)0);
            }
        }
        return info;
    }

    void clientSocketClose() {
        try {
            this.needReconnection = true;
            if (this.client != null) {
                this.client.setSoLinger(true, 0);
                this.client.close();
            }
            this.client = null;
        }
        catch (IOException e) {
            this.logException(e);
        }
        this.clearPooledUStatements();
        this.deferred_close_handle.clear();
    }

    UInputBuffer send_recv_msg(boolean recv_result) throws UJciException, IOException {
        byte[] prev_casinfo = this.casinfo;
        this.outBuffer.sendData();
        UInputBuffer inputBuffer = new UInputBuffer(this.input, this);
        if (UJCIUtil.isConsoleDebug()) {
            UConnection.printCasInfo(prev_casinfo, this.casinfo);
        }
        return inputBuffer;
    }

    UInputBuffer send_recv_msg() throws UJciException, IOException {
        if (this.client == null) {
            this.createJciException(-21003);
        }
        return this.send_recv_msg(true);
    }

    void cancel() throws UJciException, IOException {
        if (this.protoVersionIsAbove(4)) {
            BrokerHandler.cancelBrokerEx(this.CASIp, this.CASPort, this.processId, 0);
        } else {
            BrokerHandler.cancelBroker(this.CASIp, this.CASPort, this.processId, 0);
        }
    }

    UUrlCache getUrlCache() {
        if (this.url_cache == null) {
            UUrlHostKey key = new UUrlHostKey(this.CASIp, this.CASPort, this.dbname, this.user);
            this.url_cache = UJCIManager.getUrlCache(key);
        }
        return this.url_cache;
    }

    private int getTimeout(long endTimestamp, int timeout) throws UJciException {
        if (endTimestamp == 0L) {
            return timeout;
        }
        long diff = endTimestamp - System.currentTimeMillis();
        if (diff <= 0L) {
            throw new UJciException(-21024);
        }
        if (diff < (long)timeout) {
            return (int)diff;
        }
        return timeout;
    }

    private void reconnectWorker(long endTimestamp) throws IOException, UJciException {
        if (UJCIUtil.isConsoleDebug()) {
            CUBRIDDriver.printDebug(String.format("Try Connect (%s,%d)", this.CASIp, this.CASPort));
        }
        int timeout = this.connectionProperties.getConnectTimeout() * 1000;
        this.client = BrokerHandler.connectBroker(this.CASIp, this.CASPort, this.getTimeout(endTimestamp, timeout));
        this.output = new DataOutputStream(this.client.getOutputStream());
        this.input = new UTimedDataInputStream(this.client.getInputStream(), this.CASIp, this.CASPort);
        this.connectDB(this.getTimeout(endTimestamp, timeout));
        this.client.setTcpNoDelay(true);
        this.client.setSoTimeout(5000);
        this.needReconnection = false;
        this.isClosed = false;
        if (this.lastIsolationLevel != 0) {
            this.setIsolationLevel(this.lastIsolationLevel);
        }
        if (this.lastLockTimeout != -2) {
            this.setLockTimeout(this.lastLockTimeout);
        }
    }

    private void connectDB(int timeout) throws IOException, UJciException {
        UTimedDataInputStream is = new UTimedDataInputStream(this.client.getInputStream(), this.CASIp, this.CASPort, timeout);
        DataOutputStream os = new DataOutputStream(this.client.getOutputStream());
        os.write(this.dbInfo);
        int dataLength = is.readInt();
        this.casinfo = new byte[4];
        is.readFully(this.casinfo);
        if (dataLength < 0) {
            throw new UJciException(-21019);
        }
        int response = is.readInt();
        if (response < 0) {
            int code = is.readInt();
            if (response == -1 && code > -10000 || code == -1018) {
                code -= 9000;
            }
            byte[] msg = new byte[dataLength - 8];
            is.readFully(msg);
            throw new UJciException(-21002, response, code, new String(msg, 0, msg.length - 1));
        }
        this.processId = response;
        if (this.broker_info == null) {
            this.broker_info = new byte[8];
        }
        is.readFully(this.broker_info);
        byte version = this.broker_info[4];
        this.brokerVersion = (version & 0x40) == 64 ? this.makeProtoVersion(version & 0x3F) : this.makeBrokerVersion(this.broker_info[4], this.broker_info[5], this.broker_info[6]);
        this.casId = this.protoVersionIsAbove(4) ? is.readInt() : -1;
        if (this.protoVersionIsAbove(3)) {
            is.readFully(this.sessionId);
        } else {
            this.oldSessionId = is.readInt();
        }
    }

    private boolean setActiveHost(int hostId) throws UJciException {
        if (hostId >= this.altHosts.size()) {
            return false;
        }
        String info = this.altHosts.get(hostId);
        this.setConnectInfo(info);
        return true;
    }

    private long getLoginEndTimestamp(long timestamp) {
        int timeout = this.connectionProperties.getConnectTimeout();
        if (timeout <= 0) {
            return 0L;
        }
        return timestamp + (long)(timeout * 1000);
    }

    private void reconnect() throws IOException, UJciException {
        if (this.altHosts != null) {
            int retry = 0;
            do {
                for (int hostId = 0; hostId < this.altHosts.size(); ++hostId) {
                    if (!CUBRIDDriver.isUnreachableHost(this.altHosts.get(hostId)) || retry == 1) {
                        try {
                            this.setActiveHost(hostId);
                            this.reconnectWorker(this.getLoginEndTimestamp(System.currentTimeMillis()));
                            this.connectedHostId = hostId;
                            CUBRIDDriver.unreachableHosts.remove(this.altHosts.get(hostId));
                            return;
                        }
                        catch (IOException e) {
                            this.logException(e);
                            throw e;
                        }
                        catch (UJciException e) {
                            this.logException(e);
                            int errno = e.getJciError();
                            if (errno == -21003 || errno == -21013 || errno == -21024 || errno == -10017) {
                                CUBRIDDriver.addToUnreachableHosts(this.altHosts.get(hostId));
                            }
                            throw e;
                        }
                    }
                    this.lastFailureTime = System.currentTimeMillis() / 1000L;
                }
            } while (++retry < 2);
            throw this.createJciException(-21013);
        }
        this.reconnectWorker(this.getLoginEndTimestamp(this.beginTime));
    }

    private int makeBrokerVersion(int major, int minor, int patch) {
        int version = 0;
        if (major < 0 || major > 127 || minor < 0 || minor > 127 || patch < 0 || patch > 127) {
            return 0;
        }
        version = major << 24 | minor << 16 | patch << 8;
        return version;
    }

    private int makeProtoVersion(int ver) {
        return 0x40000000 | ver;
    }

    public int brokerInfoVersion() {
        return this.brokerVersion;
    }

    public boolean protoVersionIsSame(int ver) {
        return this.brokerInfoVersion() == this.makeProtoVersion(ver);
    }

    public boolean protoVersionIsUnder(int ver) {
        return this.brokerInfoVersion() < this.makeProtoVersion(ver);
    }

    public boolean protoVersionIsAbove(int ver) {
        return this.isServerSideJdbc() || this.brokerInfoVersion() >= this.makeProtoVersion(ver);
    }

    private void setConnectInfo(String info) throws UJciException {
        StringTokenizer st = new StringTokenizer(info, ":");
        if (st.countTokens() != 2) {
            throw this.createJciException(-21013);
        }
        this.CASIp = st.nextToken();
        this.CASPort = Integer.valueOf(st.nextToken());
    }

    private void manageElementOfSequence(CUBRIDOID oid, String attributeName, int index, Object value, byte flag) throws UJciException, IOException {
        UAParameter aParameter = new UAParameter(attributeName, value);
        this.setBeginTime();
        this.checkReconnect();
        if (this.errorHandler.getErrorCode() != 0) {
            return;
        }
        this.outBuffer.newRequest(this.output, (byte)18);
        this.outBuffer.addByte(flag);
        this.outBuffer.addOID(oid);
        this.outBuffer.addInt(index);
        aParameter.writeParameter(this.outBuffer);
        this.send_recv_msg();
    }

    private void manageElementOfSet(CUBRIDOID oid, String attributeName, Object value, byte flag) throws UJciException, IOException {
        UAParameter aParameter = new UAParameter(attributeName, value);
        this.setBeginTime();
        this.checkReconnect();
        if (this.errorHandler.getErrorCode() != 0) {
            return;
        }
        this.outBuffer.newRequest(this.output, (byte)18);
        this.outBuffer.addByte(flag);
        this.outBuffer.addOID(oid);
        aParameter.writeParameter(this.outBuffer);
        this.send_recv_msg();
    }

    void checkReconnect() throws IOException, UJciException {
        if (this.dbInfo == null) {
            this.dbInfo = UConnection.createDBInfo(this.dbname, this.user, this.passwd, this.url);
        }
        if (this.brokerInfoVersion() == 0) {
            String id = "0";
            UJCIUtil.copy_bytes(this.dbInfo, 608, 20, id);
        } else if (this.protoVersionIsAbove(3)) {
            System.arraycopy(this.sessionId, 0, this.dbInfo, 608, 20);
        } else {
            UJCIUtil.copy_bytes(this.dbInfo, 608, 20, new Integer(this.oldSessionId).toString());
        }
        if (this.outBuffer == null) {
            this.outBuffer = new UOutputBuffer(this);
        }
        if (this.pooled_ustmts == null) {
            this.pooled_ustmts = new Vector();
        }
        if (this.deferred_close_handle == null) {
            this.deferred_close_handle = new Vector();
        }
        if (!this.isServerSideJdbc) {
            if (this.getCASInfoStatus() == 0 && !this.check_cas()) {
                this.clientSocketClose();
            }
            if (this.needReconnection) {
                this.reconnect();
                if (UJCIUtil.isSendAppInfo()) {
                    this.sendAppInfo();
                }
            }
        }
    }

    private void sendAppInfo() {
        String msg = CUBRIDJdbcInfoTable.getValue();
        if (msg == null) {
            return;
        }
        this.check_cas(msg);
    }

    public void closeSession() {
        try {
            this.setBeginTime();
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return;
            }
            this.outBuffer.newRequest(this.output, (byte)38);
            this.send_recv_msg();
            this.sessionId = this.createNullSession();
            this.oldSessionId = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private byte[] createNullSession() {
        return new byte[20];
    }

    private void disconnect() {
        try {
            this.setBeginTime();
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return;
            }
            this.outBuffer.newRequest(this.output, (byte)31);
            this.send_recv_msg();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void clearPooledUStatements() {
        if (this.pooled_ustmts == null) {
            return;
        }
        while (!this.pooled_ustmts.isEmpty()) {
            UStatement tmp_ustmt = this.pooled_ustmts.remove(0);
            if (tmp_ustmt == null) continue;
            tmp_ustmt.close(false);
        }
    }

    public boolean isServerSideJdbc() {
        return this.isServerSideJdbc;
    }

    public void turnOnAutoCommitBySelf() {
        this.isAutoCommitBySelf = true;
    }

    public void turnOffAutoCommitBySelf() {
        this.isAutoCommitBySelf = false;
    }

    public void setConnectionProperties(ConnectionProperties connProperties) {
        this.connectionProperties = connProperties;
    }

    private Log getLogger() {
        if (this.log == null) {
            this.log = new BasicLogger(this.connectionProperties.getLogFile());
        }
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UJciException createJciException(int err) {
        UJciException e = new UJciException(err);
        if (this.connectionProperties == null || !this.connectionProperties.getLogOnException()) {
            return e;
        }
        StringBuffer b = new StringBuffer();
        b.append("DUMP EXCEPTION\n");
        b.append("[JCI EXCEPTION]");
        UConnection uConnection = this;
        synchronized (uConnection) {
            this.getLogger().logInfo(b.toString(), e);
        }
        return e;
    }

    public UJciException createJciException(int err, int indicator, int srv_err, String msg) {
        UJciException e = new UJciException(err, indicator, srv_err, msg);
        this.logException(e);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logException(Throwable t) {
        if (this.connectionProperties == null || !this.connectionProperties.getLogOnException()) {
            return;
        }
        StringBuffer b = new StringBuffer();
        b.append("DUMP EXCEPTION\n");
        b.append("[" + t.getClass().getName() + "]");
        UConnection uConnection = this;
        synchronized (uConnection) {
            this.getLogger().logInfo(b.toString(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logSlowQuery(long begin, long end, String sql, UBindParameter p) {
        if (this.connectionProperties == null || !this.connectionProperties.getLogSlowQueris()) {
            return;
        }
        long elapsed = end - begin;
        if ((long)this.connectionProperties.getSlowQueryThresholdMillis() > elapsed) {
            return;
        }
        StringBuffer b = new StringBuffer();
        b.append("SLOW QUERY\n");
        b.append(String.format("[CAS INFO]\n%s:%d, %d, %d\n", this.CASIp, this.CASPort, this.casId, this.processId));
        b.append(String.format("[TIME]\nSTART: %s, ELAPSED: %d\n", this.dateFormat.format(new Date(begin)), elapsed));
        b.append("[SQL]\n").append(sql).append('\n');
        if (p != null) {
            b.append("[BIND]\n");
            for (int i = 0; i < p.values.length; ++i) {
                if (i != 0) {
                    b.append(", ");
                }
                b.append(p.values[i].toString());
            }
            b.append('\n');
        }
        UConnection uConnection = this;
        synchronized (uConnection) {
            this.getLogger().logInfo(b.toString());
        }
    }

    public boolean isActive() {
        return this.getCASInfoStatus() == 1;
    }

    public void setBeginTime() {
        this.beginTime = System.currentTimeMillis();
    }

    public long getRemainingTime(long timeout) {
        if (this.beginTime == 0L || timeout == 0L) {
            return timeout;
        }
        long now = System.currentTimeMillis();
        return timeout - (now - this.beginTime);
    }

    public void resetBeginTime() {
        this.beginTime = 0L;
    }

    public boolean isRenewedSessionId() {
        return this.brokerInfoReconnectWhenServerDown() && (this.casinfo[3] & 4) == 4;
    }

    public void setNewSessionId(byte[] newSessionId) {
        this.sessionId = newSessionId;
    }

    public void setShardId(int shardId) {
        this.lastShardId = shardId;
    }

    public int getShardId() {
        return this.lastShardId;
    }

    public int getShardCount() {
        int num_shard;
        if (!this.isConnectedToProxy()) {
            return 0;
        }
        if (this.numShard == 0 && ((num_shard = this.shardInfo()) == 0 || this.errorHandler.getErrorCode() != 0)) {
            return 0;
        }
        return this.numShard;
    }

    public synchronized int shardInfo() {
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return 0;
        }
        if (!this.isConnectedToProxy()) {
            this.errorHandler.setErrorCode(-21025);
            return 0;
        }
        if (this.numShard > 0) {
            return this.numShard;
        }
        try {
            this.setBeginTime();
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return 0;
            }
            this.outBuffer.newRequest(this.output, (byte)43);
            UInputBuffer inBuffer = this.send_recv_msg();
            int num_shard = inBuffer.getResCode();
            if (num_shard > 0) {
                this.shardInfo = new UShardInfo[num_shard];
                for (int i = 0; i < num_shard; ++i) {
                    this.shardInfo[i] = new UShardInfo(inBuffer.readInt());
                    this.shardInfo[i].setDBName(inBuffer.readString(inBuffer.readInt(), UJCIManager.sysCharsetName));
                    this.shardInfo[i].setDBServer(inBuffer.readString(inBuffer.readInt(), UJCIManager.sysCharsetName));
                }
                this.numShard = num_shard;
            }
        }
        catch (UJciException e) {
            this.logException(e);
            e.toUError(this.errorHandler);
        }
        catch (IOException e) {
            this.logException(e);
            this.errorHandler.setErrorCode(-21003);
        }
        return this.numShard;
    }

    public synchronized UShardInfo getShardInfo(int shard_id) {
        int num_shard;
        this.errorHandler = new UError(this);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return null;
        }
        if (!this.isConnectedToProxy()) {
            this.errorHandler.setErrorCode(-21025);
            return null;
        }
        if (this.numShard == 0 && ((num_shard = this.shardInfo()) == 0 || this.errorHandler.getErrorCode() != 0)) {
            return null;
        }
        if (shard_id < 0 || shard_id >= this.numShard) {
            this.errorHandler.setErrorCode(-21026);
            return null;
        }
        return this.shardInfo[shard_id];
    }

    static {
        UJCIUtil.copy_bytes(driverInfo, 0, 5, magicString);
        UConnection.driverInfo[5] = 3;
        UConnection.driverInfo[6] = 70;
        UConnection.driverInfo[7] = -64;
        UConnection.driverInfo[8] = 0;
        UConnection.driverInfo[9] = 0;
    }
}

