/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.jci.UErrorCode;
import cubrid.jdbc.net.BrokerHandler;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;

public class UTimedDataInputStream {
    public static final int PING_TIMEOUT = 5000;
    private DataInputStream stream = null;
    private String ip = null;
    private int port = 0;
    private int timeout = 0;

    public UTimedDataInputStream(InputStream stream, String ip, int port) {
        this(stream, ip, port, 0);
    }

    public UTimedDataInputStream(InputStream stream, String ip, int port, int timeout) {
        this.stream = new DataInputStream(stream);
        this.ip = ip;
        this.port = port;
        this.timeout = timeout;
    }

    public int readInt(int timeout) throws IOException {
        long begin = System.currentTimeMillis();
        while (true) {
            try {
                return this.stream.readInt();
            }
            catch (SocketTimeoutException e) {
                if (timeout > 0 && (long)timeout - (System.currentTimeMillis() - begin) <= 0L) {
                    String msg = UErrorCode.codeToMessage(-21024);
                    throw new SocketTimeoutException(msg);
                }
                BrokerHandler.pingBroker(this.ip, this.port, 5000);
                continue;
            }
            break;
        }
    }

    public int readInt() throws IOException {
        return this.readInt(this.timeout);
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, this.timeout);
    }

    public void readFully(byte[] b, int timeout) throws IOException {
        long begin = System.currentTimeMillis();
        while (true) {
            try {
                this.stream.readFully(b);
                return;
            }
            catch (SocketTimeoutException e) {
                if (timeout > 0 && (long)timeout - (System.currentTimeMillis() - begin) <= 0L) {
                    String msg = UErrorCode.codeToMessage(-21024);
                    throw new SocketTimeoutException(msg);
                }
                BrokerHandler.pingBroker(this.ip, this.port, 5000);
                continue;
            }
            break;
        }
    }

    public int readByte(byte[] b, int timeout) throws IOException {
        long begin = System.currentTimeMillis();
        while (true) {
            try {
                return this.stream.read(b);
            }
            catch (SocketTimeoutException e) {
                if (timeout > 0 && (long)timeout - (System.currentTimeMillis() - begin) <= 0L) {
                    String msg = UErrorCode.codeToMessage(-21024);
                    throw new SocketTimeoutException(msg);
                }
                BrokerHandler.pingBroker(this.ip, this.port, 5000);
                continue;
            }
            break;
        }
    }

    public int readByte(byte[] b) throws IOException {
        return this.readByte(b, this.timeout);
    }

    public int read(byte[] b, int off, int len, int timeout) throws IOException {
        long begin = System.currentTimeMillis();
        while (true) {
            try {
                return this.stream.read(b, off, len);
            }
            catch (SocketTimeoutException e) {
                if (timeout > 0 && (long)timeout - (System.currentTimeMillis() - begin) <= 0L) {
                    String msg = UErrorCode.codeToMessage(-21024);
                    throw new SocketTimeoutException(msg);
                }
                BrokerHandler.pingBroker(this.ip, this.port, 5000);
                continue;
            }
            break;
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.read(b, off, len, this.timeout);
    }

    public void close() throws IOException {
        this.stream.close();
    }
}

