/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.net;

import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UErrorCode;
import cubrid.jdbc.jci.UJciException;
import cubrid.jdbc.jci.UTimedDataInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class BrokerHandler {
    private static int TIMEOUT_UNIT = 1000;
    private static byte[] PING_INFO = new byte[]{80, 73, 78, 71, 0, 0, 0, 0, 0, 0};
    private static byte[] CANCEL_INFO = new byte[]{67, 65, 78, 67, 69, 76};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Socket connectBroker(String ip, int port, int timeout) throws IOException, UJciException {
        Socket toBroker = null;
        UTimedDataInputStream in = null;
        DataOutputStream out = null;
        long begin = System.currentTimeMillis();
        try {
            toBroker = new Socket();
            InetSocketAddress brokerAddress = new InetSocketAddress(ip, port);
            if (timeout <= 0) {
                toBroker.connect(brokerAddress);
            } else {
                toBroker.connect(brokerAddress, timeout);
                timeout = (int)((long)timeout - (System.currentTimeMillis() - begin));
                if (timeout <= 0) {
                    toBroker.close();
                    throw new UJciException(-21024);
                }
            }
            toBroker.setSoTimeout(TIMEOUT_UNIT);
            toBroker.setKeepAlive(true);
            in = new UTimedDataInputStream(toBroker.getInputStream(), ip, port, timeout);
            out = new DataOutputStream(toBroker.getOutputStream());
            out.write(UConnection.driverInfo);
            out.flush();
            int code = in.readInt();
            if (code < 0) {
                if (code <= -10000) throw new UJciException(code);
                code -= 9000;
                throw new UJciException(code);
            }
            if (code == 0) {
                return toBroker;
            }
            toBroker.setSoLinger(true, 0);
            toBroker.close();
            toBroker = new Socket();
            brokerAddress = new InetSocketAddress(ip, code);
            if (timeout <= 0) {
                toBroker.connect(brokerAddress);
            } else {
                if ((timeout = (int)((long)timeout - (System.currentTimeMillis() - begin))) <= 0) {
                    throw new UJciException(-21024);
                }
                toBroker.connect(brokerAddress, timeout);
            }
            toBroker.setKeepAlive(true);
            return toBroker;
        }
        catch (SocketTimeoutException e) {
            if (toBroker == null) throw new UJciException(-21024, (Throwable)e);
            toBroker.close();
            throw new UJciException(-21024, (Throwable)e);
        }
        catch (IOException e) {
            if (toBroker == null) throw new UJciException(-21013, (Throwable)e);
            toBroker.close();
            throw new UJciException(-21013, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pingBroker(String ip, int port, int timeout) throws IOException {
        Socket toBroker = null;
        FilterInputStream in = null;
        FilterOutputStream out = null;
        long begin = System.currentTimeMillis();
        try {
            toBroker = new Socket();
            InetSocketAddress brokerAddress = new InetSocketAddress(ip, port);
            if (timeout <= 0) {
                toBroker.connect(brokerAddress);
            } else {
                toBroker.connect(brokerAddress, timeout);
                timeout = (int)((long)timeout - (System.currentTimeMillis() - begin));
                if (timeout <= 0) {
                    String msg = UErrorCode.codeToMessage(-21024);
                    throw new SocketTimeoutException(msg);
                }
                toBroker.setSoTimeout(timeout);
            }
            in = new DataInputStream(toBroker.getInputStream());
            out = new DataOutputStream(toBroker.getOutputStream());
            out.write(PING_INFO);
            ((DataOutputStream)out).flush();
            ((DataInputStream)in).readInt();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            if (toBroker != null) {
                toBroker.close();
            }
        }
    }

    private static void cancelRequest(String ip, int port, byte[] data, int timeout) throws IOException, UJciException {
        Socket toBroker = null;
        FilterInputStream in = null;
        FilterOutputStream out = null;
        long begin = System.currentTimeMillis();
        try {
            toBroker = new Socket();
            InetSocketAddress brokerAddress = new InetSocketAddress(ip, port);
            if (timeout <= 0) {
                toBroker.connect(brokerAddress);
            } else {
                toBroker.connect(brokerAddress, timeout);
                timeout = (int)((long)timeout - (System.currentTimeMillis() - begin));
                if (timeout <= 0) {
                    throw new UJciException(-21024);
                }
                toBroker.setSoTimeout(timeout);
            }
            in = new DataInputStream(toBroker.getInputStream());
            out = new DataOutputStream(toBroker.getOutputStream());
            out.write(data);
            ((DataOutputStream)out).flush();
            int error = ((DataInputStream)in).readInt();
            if (error < 0) {
                throw new UJciException(-10019);
            }
        }
        catch (SocketTimeoutException e) {
            throw new UJciException(-21024);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            if (toBroker != null) {
                toBroker.close();
            }
        }
    }

    public static void cancelBroker(String ip, int port, int process, int timeout) throws IOException, UJciException {
        ByteArrayOutputStream bao = new ByteArrayOutputStream(10);
        DataOutputStream dao = new DataOutputStream(bao);
        dao.write(CANCEL_INFO);
        dao.writeInt(process);
        BrokerHandler.cancelRequest(ip, port, bao.toByteArray(), timeout);
    }

    public static void cancelBrokerEx(String ip, int port, int process, int timeout) throws IOException, UJciException {
        ByteArrayOutputStream bao = new ByteArrayOutputStream(10);
        DataOutputStream dao = new DataOutputStream(bao);
        dao.write(88);
        dao.write(49);
        dao.write(UConnection.driverInfo[6]);
        dao.write(UConnection.driverInfo[7]);
        dao.write(UConnection.driverInfo[8]);
        dao.write(UConnection.driverInfo[9]);
        dao.writeInt(process);
        BrokerHandler.cancelRequest(ip, port, bao.toByteArray(), timeout);
    }
}

