/*
 * Decompiled with CFR 0.152.
 */
package com.karasiq.tls.internal;

import com.karasiq.tls.TLS;
import com.karasiq.tls.internal.BCConversions$CipherSuiteId$;
import com.karasiq.tls.x509.CertificateVerifier;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import java.security.Provider;
import java.util.Vector;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAKeyParameters;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.tls.CertificateRequest;
import org.bouncycastle.crypto.tls.HashAlgorithm;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class TLSUtils$ {
    public static TLSUtils$ MODULE$;
    private final Provider provider;
    private final Config config;

    static {
        new TLSUtils$();
    }

    public Provider provider() {
        return this.provider;
    }

    private Config config() {
        return this.config;
    }

    public SignatureAndHashAlgorithm signatureAlgorithm(AsymmetricKeyParameter key, String hashAlgorithm) {
        short hash = BoxesRunTime.unboxToShort((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcS.sp & Serializable & scala.Serializable)() -> HashAlgorithm.class.getField(hashAlgorithm.replace("-", "").toLowerCase()).getShort(null)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid hash algorithm: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hashAlgorithm})));
        }));
        AsymmetricKeyParameter asymmetricKeyParameter = key;
        int n = asymmetricKeyParameter instanceof RSAKeyParameters ? 1 : (asymmetricKeyParameter instanceof ECKeyParameters ? 3 : (asymmetricKeyParameter instanceof DSAKeyParameters ? 2 : 0));
        int sign = n;
        return new SignatureAndHashAlgorithm(hash, (short)sign);
    }

    public String signatureAlgorithm$default$2() {
        return this.defaultHashAlgorithm();
    }

    private Vector<?> authoritiesOf(CertificateVerifier trustStore) {
        return TLSUtils$.asJavaVector$1((GenTraversableOnce)trustStore.trustedRootCertificates().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getSubject(), Set$.MODULE$.canBuildFrom()));
    }

    public CertificateRequest certificateRequest(ProtocolVersion protocolVersion, CertificateVerifier verifier) {
        short[] certificateTypes = new short[]{1, 64, 2};
        return new CertificateRequest(certificateTypes, this.defaultSignatureAlgorithms(protocolVersion), this.authoritiesOf(verifier));
    }

    public Option<TLS.CertificateKey> certificateFor(TLS.KeySet keySet, CertificateRequest certificateRequest) {
        TLS.CertificateKey[] keys = (TLS.CertificateKey[])new ArrayOps.ofShort(Predef$.MODULE$.shortArrayOps(certificateRequest.getCertificateTypes())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> TLSUtils$.$anonfun$certificateFor$1(keySet, BoxesRunTime.unboxToShort((Object)x0$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TLS.CertificateKey.class)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keys)).find((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)TLSUtils$.MODULE$.isInAuthorities(key.certificateChain(), certificateRequest)));
    }

    public boolean isInAuthorities(org.bouncycastle.crypto.tls.Certificate chain, CertificateRequest certificateRequest) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])chain.getCertificateList())).exists((Function1 & Serializable & scala.Serializable)cert -> BoxesRunTime.boxToBoolean((boolean)TLSUtils$.$anonfun$isInAuthorities$1(certificateRequest, cert)));
    }

    private ProtocolVersion asProtocolVersion(String string) {
        ProtocolVersion protocolVersion;
        String string2 = string;
        if ("SSLv3".equals(string2)) {
            protocolVersion = ProtocolVersion.SSLv3;
        } else {
            boolean bl = "TLSv1".equals(string2) ? true : "TLSv1.0".equals(string2);
            if (bl) {
                protocolVersion = ProtocolVersion.TLSv10;
            } else if ("TLSv1.1".equals(string2)) {
                protocolVersion = ProtocolVersion.TLSv11;
            } else if ("TLSv1.2".equals(string2)) {
                protocolVersion = ProtocolVersion.TLSv12;
            } else {
                boolean bl2 = "DTLSv1".equals(string2) ? true : "DTLSv1.0".equals(string2);
                if (bl2) {
                    protocolVersion = ProtocolVersion.DTLSv10;
                } else if ("DTLSv1.2".equals(string2)) {
                    protocolVersion = ProtocolVersion.DTLSv12;
                } else {
                    throw new IllegalArgumentException("Invalid TLS version: " + string);
                }
            }
        }
        return protocolVersion;
    }

    public int[] defaultCipherSuites() {
        return (int[])((TraversableOnce)Predef.Ensuring$.MODULE$.ensuring$extension3(Predef$.MODULE$.Ensuring(JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.config().getStringList("cipher-suites")).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)BCConversions$CipherSuiteId$.MODULE$.apply(x$2)), Buffer$.MODULE$.canBuildFrom())), (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.nonEmpty()), (Function0 & Serializable & scala.Serializable)() -> "Cipher suites is empty")).toArray(ClassTag$.MODULE$.Int());
    }

    public String defaultHashAlgorithm() {
        return this.config().getString("hash-algorithm");
    }

    public Vector<?> defaultSignatureAlgorithms(ProtocolVersion protocolVersion) {
        return TlsUtils.isSignatureAlgorithmsExtensionAllowed((ProtocolVersion)protocolVersion) ? TlsUtils.getDefaultSupportedSignatureAlgorithms() : null;
    }

    public ProtocolVersion minVersion() {
        return this.asProtocolVersion(this.config().getString("min-version"));
    }

    public ProtocolVersion maxVersion() {
        return this.asProtocolVersion(this.config().getString("max-version"));
    }

    public ECParameterSpec getEllipticCurve(String name) {
        return (ECParameterSpec)Option$.MODULE$.apply((Object)ECNamedCurveTable.getParameterSpec((String)name)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Elliptic curve not defined: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final Vector asJavaVector$1(GenTraversableOnce data) {
        void var1_1;
        Vector vector = new Vector();
        data.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)vector.add(x$1)));
        return var1_1;
    }

    public static final /* synthetic */ Iterable $anonfun$certificateFor$1(TLS.KeySet keySet$1, short x0$1) {
        Iterable iterable;
        short s = x0$1;
        switch (s) {
            case 64: {
                iterable = Option$.MODULE$.option2Iterable(keySet$1.ecdsa());
                break;
            }
            case 1: {
                iterable = Option$.MODULE$.option2Iterable(keySet$1.rsa());
                break;
            }
            case 2: {
                iterable = Option$.MODULE$.option2Iterable(keySet$1.dsa());
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToShort((short)s));
            }
        }
        return iterable;
    }

    public static final /* synthetic */ boolean $anonfun$isInAuthorities$1(CertificateRequest certificateRequest$2, Certificate cert) {
        return certificateRequest$2.getCertificateAuthorities().contains(cert.getSubject()) || certificateRequest$2.getCertificateAuthorities().contains(cert.getIssuer());
    }

    private TLSUtils$() {
        MODULE$ = this;
        this.provider = new BouncyCastleProvider();
        this.config = ConfigFactory.load().getConfig("karasiq.tls");
    }
}

