/*
 * Decompiled with CFR 0.152.
 */
package com.karasiq.tls.x509.crl;

import com.karasiq.tls.TLS;
import com.karasiq.tls.internal.BCConversions$;
import com.karasiq.tls.internal.BCConversions$AsymmetricKeyParameterOps$;
import com.karasiq.tls.internal.ObjectLoader;
import com.karasiq.tls.x509.X509Utils$;
import com.karasiq.tls.x509.crl.CRLBuilder;
import com.karasiq.tls.x509.crl.CRLHolder;
import com.karasiq.tls.x509.crl.CRLReader;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509ExtensionUtils;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.operator.ContentSigner;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.math.BigInt;

public final class CRL$
implements CRLBuilder,
CRLReader {
    public static CRL$ MODULE$;
    private final Config config;

    static {
        new CRL$();
    }

    @Override
    public X509CRLHolder fromInputStream(InputStream inputStream) {
        return CRLReader.fromInputStream$(this, inputStream);
    }

    @Override
    public boolean verify(X509CRLHolder crl, Certificate issuer) {
        return CRLReader.verify$(this, crl, issuer);
    }

    @Override
    public boolean contains(X509CRLHolder crl, Certificate cert) {
        return CRLReader.contains$(this, crl, cert);
    }

    @Override
    public Seq<X509CRLHolder> getRevocationLists(Certificate cert, Certificate issuer) {
        return CRLReader.getRevocationLists$(this, cert, issuer);
    }

    @Override
    public Object fromResource(String resource) {
        return ObjectLoader.fromResource$(this, resource);
    }

    @Override
    public Object fromFile(File file) {
        return ObjectLoader.fromFile$((ObjectLoader)this, file);
    }

    @Override
    public final Object fromFile(Path file) {
        return ObjectLoader.fromFile$((ObjectLoader)this, file);
    }

    @Override
    public final Object fromFile(String file) {
        return ObjectLoader.fromFile$((ObjectLoader)this, file);
    }

    @Override
    public Object fromURL(URL url) {
        return ObjectLoader.fromURL$((ObjectLoader)this, url);
    }

    @Override
    public final Object fromURL(String url) {
        return ObjectLoader.fromURL$((ObjectLoader)this, url);
    }

    @Override
    public final Object fromURI(URI uri) {
        return ObjectLoader.fromURI$(this, uri);
    }

    @Override
    public Object fromBytes(byte[] bytes) {
        return ObjectLoader.fromBytes$(this, bytes);
    }

    @Override
    public final Object fromByteBuffer(ByteBuffer byteBuffer) {
        return ObjectLoader.fromByteBuffer$(this, byteBuffer);
    }

    @Override
    public final Object fromString(String str, String encoding) {
        return ObjectLoader.fromString$(this, str, encoding);
    }

    @Override
    public final Object fromString(String str) {
        return ObjectLoader.fromString$(this, str);
    }

    private Config config() {
        return this.config;
    }

    public String defaultKeyIdAlgorithm() {
        return this.config().getString("key-id-algorithm");
    }

    public String defaultSignAlgorithm() {
        return this.config().getString("sign-algorithm");
    }

    public Instant defaultNextUpdate() {
        return Instant.now().plus(this.config().getDuration("next-update-in", TimeUnit.SECONDS), ChronoUnit.SECONDS);
    }

    private X509v2CRLBuilder addSerial(X509v2CRLBuilder builder, TLS.CertificateKey issuer, BigInteger serial, int reason, Instant revocationDate) {
        ExtensionsGenerator extGen = new ExtensionsGenerator();
        extGen.addExtension(Extension.reasonCode, false, (ASN1Encodable)CRLReason.lookup((int)reason));
        extGen.addExtension(Extension.certificateIssuer, true, (ASN1Encodable)new GeneralNames(new GeneralName(issuer.certificate().getSubject())));
        return builder.addCRLEntry(serial, Date.from(revocationDate), extGen.generate());
    }

    @Override
    public X509CRLHolder build(TLS.CertificateKey issuer, Seq<CRLHolder.Revoked> revoked, Instant nextUpdate) {
        Predef$.MODULE$.assert(X509Utils$.MODULE$.isKeyUsageAllowed(issuer.certificate(), 2), (Function0 & Serializable & scala.Serializable)() -> "CRL signing not allowed");
        X509v2CRLBuilder builder = new X509v2CRLBuilder(issuer.certificate().getSubject(), new Date());
        X509ExtensionUtils extensionUtils = X509Utils$.MODULE$.extensionUtils(this.defaultKeyIdAlgorithm());
        ContentSigner contentSigner = X509Utils$.MODULE$.contentSigner(BCConversions$AsymmetricKeyParameterOps$.MODULE$.toPrivateKey$extension(BCConversions$.MODULE$.AsymmetricKeyParameterOps(issuer.key().getPrivate())), this.defaultSignAlgorithm());
        builder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extensionUtils.createAuthorityKeyIdentifier(new X509CertificateHolder(issuer.certificate())));
        builder.setNextUpdate(Date.from(nextUpdate));
        revoked.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            X509v2CRLBuilder x509v2CRLBuilder;
            CRLHolder.Revoked revoked = x0$1;
            if (revoked instanceof CRLHolder.RevokedCerts) {
                CRLHolder.RevokedCerts revokedCerts = (CRLHolder.RevokedCerts)revoked;
                X509CRLHolder crl = revokedCerts.crl();
                x509v2CRLBuilder = builder.addCRL(crl);
            } else if (revoked instanceof CRLHolder.RevokedCert) {
                CRLHolder.RevokedCert revokedCert = (CRLHolder.RevokedCert)revoked;
                Certificate cert = revokedCert.cert();
                int reason = revokedCert.reason();
                Instant revocationDate = revokedCert.revocationDate();
                x509v2CRLBuilder = MODULE$.addSerial(builder, issuer, cert.getSerialNumber().getValue(), reason, revocationDate);
            } else if (revoked instanceof CRLHolder.RevokedSerial) {
                CRLHolder.RevokedSerial revokedSerial = (CRLHolder.RevokedSerial)revoked;
                BigInt serial = revokedSerial.serial();
                int reason = revokedSerial.reason();
                Instant revocationDate = revokedSerial.revocationDate();
                x509v2CRLBuilder = MODULE$.addSerial(builder, issuer, serial.underlying(), reason, revocationDate);
            } else {
                throw new MatchError((Object)revoked);
            }
            return x509v2CRLBuilder;
        });
        return builder.build(contentSigner);
    }

    public Instant build$default$3() {
        return this.defaultNextUpdate();
    }

    private CRL$() {
        MODULE$ = this;
        ObjectLoader.$init$(this);
        CRLReader.$init$(this);
        this.config = ConfigFactory.load().getConfig("karasiq.tls.crl-defaults");
    }
}

