/*
 * Decompiled with CFR 0.152.
 */
package com.karasiq.tls.x509.ocsp;

import com.karasiq.tls.TLS;
import com.karasiq.tls.internal.BCConversions$;
import com.karasiq.tls.internal.BCConversions$AsymmetricKeyParameterOps$;
import com.karasiq.tls.internal.TLSUtils$;
import com.karasiq.tls.x509.X509Utils$;
import com.karasiq.tls.x509.ocsp.OCSP;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.BasicOCSPRespBuilder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.jcajce.JcaBasicOCSPRespBuilder;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.encoders.Base64;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.math.BigInt;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class OCSP$ {
    public static OCSP$ MODULE$;
    private final DigestCalculator digestCalculator;
    private final SecureRandom secureRandom;

    static {
        new OCSP$();
    }

    private DigestCalculator digestCalculator() {
        return this.digestCalculator;
    }

    private SecureRandom secureRandom() {
        return this.secureRandom;
    }

    public CertificateID id(Certificate issuer, BigInt serial) {
        return new CertificateID(this.digestCalculator(), new X509CertificateHolder(issuer), serial.underlying());
    }

    public OCSPReq signedRequest(TLS.CertificateKey signer, Seq<CertificateID> ids) {
        OCSPReqBuilder builder2 = (OCSPReqBuilder)ids.foldLeft((Object)new OCSPReqBuilder(), (Function2 & Serializable & scala.Serializable)(builder, id) -> builder.addRequest(id));
        builder2.setRequestorName(signer.certificate().getSubject());
        ExtensionsGenerator extGen = new ExtensionsGenerator();
        byte[] bytes = new byte[16];
        this.secureRandom().nextBytes(bytes);
        DEROctetString nonce = new DEROctetString(bytes);
        extGen.addExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1Encodable)nonce);
        builder2.setRequestExtensions(extGen.generate());
        return builder2.build(X509Utils$.MODULE$.contentSigner(BCConversions$AsymmetricKeyParameterOps$.MODULE$.toPrivateKey$extension(BCConversions$.MODULE$.AsymmetricKeyParameterOps(signer.key().getPrivate())), X509Utils$.MODULE$.contentSigner$default$2()), (X509CertificateHolder[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])signer.certificateChain().getCertificateList())).map((Function1 & Serializable & scala.Serializable)x$1 -> new X509CertificateHolder(x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(X509CertificateHolder.class))));
    }

    public OCSPReq request(Seq<CertificateID> ids) {
        OCSPReqBuilder builder2 = (OCSPReqBuilder)ids.foldLeft((Object)new OCSPReqBuilder(), (Function2 & Serializable & scala.Serializable)(builder, id) -> builder.addRequest(id));
        return builder2.build();
    }

    public BasicOCSPResp response(TLS.CertificateKey signer, Seq<OCSP.Status> statuses) {
        BasicOCSPRespBuilder builder = (BasicOCSPRespBuilder)statuses.foldLeft((Object)new JcaBasicOCSPRespBuilder(BCConversions$AsymmetricKeyParameterOps$.MODULE$.toPublicKey$extension(BCConversions$.MODULE$.AsymmetricKeyParameterOps(signer.key().getPublic())), this.digestCalculator()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            OCSP.Status status;
            BasicOCSPRespBuilder b;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = new Tuple2(x0$1, x1$1);
                    if (tuple2 == null) break block2;
                    b = (BasicOCSPRespBuilder)tuple2._1();
                    status = (OCSP.Status)tuple2._2();
                    if (status != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            CertificateID id = status.id();
            CertificateStatus status2 = status.status();
            BasicOCSPRespBuilder basicOCSPRespBuilder = b.addResponse(id, status2);
            return basicOCSPRespBuilder;
        });
        return builder.build(X509Utils$.MODULE$.contentSigner(BCConversions$AsymmetricKeyParameterOps$.MODULE$.toPrivateKey$extension(BCConversions$.MODULE$.AsymmetricKeyParameterOps(signer.key().getPrivate())), X509Utils$.MODULE$.contentSigner$default$2()), (X509CertificateHolder[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])signer.certificateChain().getCertificateList())).map((Function1 & Serializable & scala.Serializable)x$2 -> new X509CertificateHolder(x$2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(X509CertificateHolder.class))), new Date());
    }

    private OCSPResp loadUrl(String url, OCSPReq request) {
        return (OCSPResp)scala.concurrent.package$.MODULE$.blocking((Function0 & Serializable & scala.Serializable)() -> {
            OCSPResp oCSPResp;
            String encoded = Base64.toBase64String((byte[])request.getEncoded());
            URL ocspUrl = new URL(url.endsWith("/") ? url + encoded : url + "/" + encoded);
            InputStream inputStream = ocspUrl.openStream();
            try {
                oCSPResp = new OCSPResp(inputStream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            return oCSPResp;
        });
    }

    public boolean verify(BasicOCSPResp r, Certificate issuer) {
        return X509Utils$.MODULE$.isKeyUsageAllowed(issuer, 2) && r.isSignatureValid(X509Utils$.MODULE$.contentVerifierProvider(issuer));
    }

    public boolean verify(OCSPReq r, Certificate issuer) {
        return X509Utils$.MODULE$.isKeyUsageAllowed(issuer, 128) && r.isSignatureValid(X509Utils$.MODULE$.contentVerifierProvider(issuer));
    }

    public Option<BasicOCSPResp> fromUrl(String ocsp, Certificate issuer, OCSPReq request) {
        BasicOCSPResp basicOCSPResp;
        OCSPResp response = this.loadUrl(ocsp, request);
        Predef$.MODULE$.assert(response.getStatus() == 0, (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OCSP error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)response.getStatus())})));
        Object object = response.getResponseObject();
        Object object2 = object instanceof BasicOCSPResp && this.verify(basicOCSPResp = (BasicOCSPResp)object, issuer) ? new Some((Object)basicOCSPResp) : None$.MODULE$;
        return object2;
    }

    public Option<OCSP.Status> getStatus(Certificate cert, Certificate issuer) {
        return X509Utils$.MODULE$.getOcspUrl(cert).flatMap((Function1 & Serializable & scala.Serializable)ocsp -> {
            CertificateID certId = MODULE$.id(issuer, package$.MODULE$.BigInt().apply(cert.getSerialNumber().getValue()));
            return ((IterableLike)Option$.MODULE$.option2Iterable(MODULE$.fromUrl((String)ocsp, issuer, MODULE$.request((Seq<CertificateID>)Predef$.MODULE$.wrapRefArray((Object[])new CertificateID[]{certId})))).toSeq().flatMap((Function1 & Serializable & scala.Serializable)x$3 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$3.getResponses())), Seq$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)OCSP$.$anonfun$getStatus$3(certId, x$4))).map((Function1 & Serializable & scala.Serializable)r -> new OCSP.Status(r.getCertID(), r.getCertStatus()));
        });
    }

    public static final /* synthetic */ boolean $anonfun$getStatus$3(CertificateID certId$1, SingleResp x$4) {
        CertificateID certificateID = x$4.getCertID();
        CertificateID certificateID2 = certId$1;
        return !(certificateID != null ? !certificateID.equals(certificateID2) : certificateID2 != null);
    }

    private OCSP$() {
        MODULE$ = this;
        this.digestCalculator = new JcaDigestCalculatorProviderBuilder().setProvider(TLSUtils$.MODULE$.provider()).build().get(CertificateID.HASH_SHA1);
        this.secureRandom = SecureRandom.getInstanceStrong();
    }
}

