/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.jaxrs;

import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.ext.AbstractSwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

public class JaxrsParameterExtension
extends AbstractSwaggerExtension {
    public List<Parameter> extractParameters(List<Annotation> annotations, Type type, Set<Type> typesToSkip, Iterator<SwaggerExtension> chain) {
        if (this.shouldIgnoreType(type, typesToSkip)) {
            return new ArrayList<Parameter>();
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        SerializableParameter parameter = null;
        for (Annotation annotation : annotations) {
            parameter = JaxrsParameterExtension.getParameter(type, parameter, annotation);
        }
        if (parameter != null) {
            parameters.add((Parameter)parameter);
        }
        return parameters;
    }

    public static SerializableParameter getParameter(Type type, SerializableParameter parameter, Annotation annotation) {
        QueryParam param;
        String defaultValue = "";
        if (annotation instanceof DefaultValue) {
            DefaultValue defaultValueAnnotation = (DefaultValue)annotation;
            defaultValue = defaultValueAnnotation.value();
        }
        if (annotation instanceof QueryParam) {
            String parameterType;
            Property schema;
            param = (QueryParam)annotation;
            QueryParameter queryParameter = (QueryParameter)new QueryParameter().name(param.value());
            if (!defaultValue.isEmpty()) {
                queryParameter.setDefaultValue(defaultValue);
            }
            if ((schema = ModelConverters.getInstance().readAsProperty(type)) != null) {
                queryParameter.setProperty(schema);
            }
            if ((parameterType = queryParameter.getType()) == null || parameterType.equals("ref")) {
                queryParameter.setType("string");
            }
            parameter = queryParameter;
        } else if (annotation instanceof PathParam) {
            String parameterType;
            Property schema;
            param = (PathParam)annotation;
            PathParameter pathParameter = (PathParameter)new PathParameter().name(param.value());
            if (!defaultValue.isEmpty()) {
                pathParameter.setDefaultValue(defaultValue);
            }
            if ((schema = ModelConverters.getInstance().readAsProperty(type)) != null) {
                pathParameter.setProperty(schema);
            }
            if ((parameterType = pathParameter.getType()) == null || parameterType.equals("ref")) {
                pathParameter.setType("string");
            }
            parameter = pathParameter;
        } else if (annotation instanceof HeaderParam) {
            String parameterType;
            param = (HeaderParam)annotation;
            HeaderParameter headerParameter = (HeaderParameter)new HeaderParameter().name(param.value());
            headerParameter.setDefaultValue(defaultValue);
            Property schema = ModelConverters.getInstance().readAsProperty(type);
            if (schema != null) {
                headerParameter.setProperty(schema);
            }
            if ((parameterType = headerParameter.getType()) == null || parameterType.equals("ref") || parameterType.equals("array")) {
                headerParameter.setType("string");
            }
            parameter = headerParameter;
        } else if (annotation instanceof CookieParam) {
            String parameterType;
            Property schema;
            param = (CookieParam)annotation;
            CookieParameter cookieParameter = (CookieParameter)new CookieParameter().name(param.value());
            if (!defaultValue.isEmpty()) {
                cookieParameter.setDefaultValue(defaultValue);
            }
            if ((schema = ModelConverters.getInstance().readAsProperty(type)) != null) {
                cookieParameter.setProperty(schema);
            }
            if ((parameterType = cookieParameter.getType()) == null || parameterType.equals("ref") || parameterType.equals("array")) {
                cookieParameter.setType("string");
            }
            parameter = cookieParameter;
        } else if (annotation instanceof FormParam) {
            String parameterType;
            Property schema;
            param = (FormParam)annotation;
            FormParameter formParameter = (FormParameter)new FormParameter().name(param.value());
            if (!defaultValue.isEmpty()) {
                formParameter.setDefaultValue(defaultValue);
            }
            if ((schema = ModelConverters.getInstance().readAsProperty(type)) != null) {
                formParameter.setProperty(schema);
            }
            if ((parameterType = formParameter.getType()) == null || parameterType.equals("ref") || parameterType.equals("array")) {
                formParameter.setType("string");
            }
            parameter = formParameter;
        }
        return parameter;
    }
}

