/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.ClientRequestAdapter;
import com.github.kristofa.brave.ClientTracer;
import com.github.kristofa.brave.KeyValueAnnotation;
import com.github.kristofa.brave.SpanId;

public class ClientRequestInterceptor {
    private final ClientTracer clientTracer;

    public ClientRequestInterceptor(ClientTracer clientTracer) {
        this.clientTracer = clientTracer;
    }

    public void handle(ClientRequestAdapter adapter) {
        SpanId spanId = this.clientTracer.startNewSpan(adapter.getSpanName());
        if (spanId == null) {
            adapter.addSpanIdToRequest(null);
        } else {
            adapter.addSpanIdToRequest(spanId);
            this.clientTracer.setCurrentClientServiceName(adapter.getClientServiceName());
            for (KeyValueAnnotation annotation : adapter.requestAnnotations()) {
                this.clientTracer.submitBinaryAnnotation(annotation.getKey(), annotation.getValue());
            }
            this.clientTracer.setClientSent();
        }
    }
}

