/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.internal.Util;
import com.twitter.zipkin.gen.AnnotationType;
import com.twitter.zipkin.gen.BinaryAnnotation;
import com.twitter.zipkin.gen.Span;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingSpanCollector
implements SpanCollector {
    private static final String UTF_8 = "UTF-8";
    private final Logger logger;
    private final Set<BinaryAnnotation> defaultAnnotations = new LinkedHashSet<BinaryAnnotation>();

    public LoggingSpanCollector() {
        this.logger = Logger.getLogger(LoggingSpanCollector.class.getName());
    }

    public LoggingSpanCollector(String loggerName) {
        Util.checkNotBlank(loggerName, "Null or blank loggerName", new Object[0]);
        this.logger = Logger.getLogger(loggerName);
    }

    @Override
    public void collect(Span span) {
        Util.checkNotNull(span, "Null span", new Object[0]);
        if (!this.defaultAnnotations.isEmpty()) {
            for (BinaryAnnotation ba : this.defaultAnnotations) {
                span.addToBinary_annotations(ba);
            }
        }
        if (this.getLogger().isLoggable(Level.INFO)) {
            this.getLogger().info(span.toString());
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void addDefaultAnnotation(String key, String value) {
        Util.checkNotBlank(key, "Null or blank key", new Object[0]);
        Util.checkNotNull(value, "Null value", new Object[0]);
        try {
            ByteBuffer bb = ByteBuffer.wrap(value.getBytes(UTF_8));
            BinaryAnnotation binaryAnnotation = new BinaryAnnotation();
            binaryAnnotation.setKey(key);
            binaryAnnotation.setValue(bb);
            binaryAnnotation.setAnnotation_type(AnnotationType.STRING);
            this.defaultAnnotations.add(binaryAnnotation);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    Logger getLogger() {
        return this.logger;
    }
}

