/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.AnnotationSubmitter;
import com.github.kristofa.brave.ClientRequestInterceptor;
import com.github.kristofa.brave.ClientResponseInterceptor;
import com.github.kristofa.brave.ClientSpanThreadBinder;
import com.github.kristofa.brave.ClientTracer;
import com.github.kristofa.brave.FixedSampleRateTraceFilter;
import com.github.kristofa.brave.InetAddressUtilities;
import com.github.kristofa.brave.LoggingSpanCollector;
import com.github.kristofa.brave.ServerAndClientSpanState;
import com.github.kristofa.brave.ServerRequestInterceptor;
import com.github.kristofa.brave.ServerResponseInterceptor;
import com.github.kristofa.brave.ServerSpanThreadBinder;
import com.github.kristofa.brave.ServerTracer;
import com.github.kristofa.brave.SpanAndEndpoint;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.ThreadLocalServerAndClientSpanState;
import com.github.kristofa.brave.TraceFilter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Brave {
    private final ServerTracer serverTracer;
    private final ClientTracer clientTracer;
    private final ServerRequestInterceptor serverRequestInterceptor;
    private final ServerResponseInterceptor serverResponseInterceptor;
    private final ClientRequestInterceptor clientRequestInterceptor;
    private final ClientResponseInterceptor clientResponseInterceptor;
    private final AnnotationSubmitter serverSpanAnnotationSubmitter;
    private final ServerSpanThreadBinder serverSpanThreadBinder;
    private final ClientSpanThreadBinder clientSpanThreadBinder;

    public ClientTracer clientTracer() {
        return this.clientTracer;
    }

    public ServerTracer serverTracer() {
        return this.serverTracer;
    }

    public ClientRequestInterceptor clientRequestInterceptor() {
        return this.clientRequestInterceptor;
    }

    public ClientResponseInterceptor clientResponseInterceptor() {
        return this.clientResponseInterceptor;
    }

    public ServerRequestInterceptor serverRequestInterceptor() {
        return this.serverRequestInterceptor;
    }

    public ServerResponseInterceptor serverResponseInterceptor() {
        return this.serverResponseInterceptor;
    }

    public ServerSpanThreadBinder serverSpanThreadBinder() {
        return this.serverSpanThreadBinder;
    }

    public ClientSpanThreadBinder clientSpanThreadBinder() {
        return this.clientSpanThreadBinder;
    }

    public AnnotationSubmitter serverSpanAnnotationSubmitter() {
        return this.serverSpanAnnotationSubmitter;
    }

    private Brave(Builder builder) {
        this.serverTracer = ServerTracer.builder().randomGenerator(builder.random).spanCollector(builder.spanCollector).state(builder.state).traceFilters(builder.traceFilters).build();
        this.clientTracer = ClientTracer.builder().randomGenerator(builder.random).spanCollector(builder.spanCollector).state(builder.state).traceFilters(builder.traceFilters).build();
        this.serverRequestInterceptor = new ServerRequestInterceptor(this.serverTracer);
        this.serverResponseInterceptor = new ServerResponseInterceptor(this.serverTracer);
        this.clientRequestInterceptor = new ClientRequestInterceptor(this.clientTracer);
        this.clientResponseInterceptor = new ClientResponseInterceptor(this.clientTracer);
        this.serverSpanAnnotationSubmitter = AnnotationSubmitter.create(SpanAndEndpoint.ServerSpanAndEndpoint.create(builder.state));
        this.serverSpanThreadBinder = new ServerSpanThreadBinder(builder.state);
        this.clientSpanThreadBinder = new ClientSpanThreadBinder(builder.state);
    }

    public static class Builder {
        private List<TraceFilter> traceFilters = new ArrayList<TraceFilter>();
        private SpanCollector spanCollector = new LoggingSpanCollector();
        private ServerAndClientSpanState state;
        private Random random = new Random();

        public Builder() {
            this("unknown");
        }

        public Builder(String serviceName) {
            try {
                InetAddress a = InetAddressUtilities.getLocalHostLANAddress();
                this.state = new ThreadLocalServerAndClientSpanState(a, 0, serviceName);
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException("Unable to get Inet address", e);
            }
            this.traceFilters.add(new FixedSampleRateTraceFilter(1));
        }

        public Builder traceFilters(List<TraceFilter> filters) {
            this.traceFilters.clear();
            this.traceFilters.addAll(filters);
            return this;
        }

        public Builder traceState(ServerAndClientSpanState state) {
            this.state = state;
            return this;
        }

        public Builder spanCollector(SpanCollector spanCollector) {
            this.spanCollector = spanCollector;
            return this;
        }

        public Brave build() {
            return new Brave(this);
        }
    }
}

