/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.AnnotationSubmitter;
import com.github.kristofa.brave.AutoValue_ClientTracer;
import com.github.kristofa.brave.ServerAndClientSpanState;
import com.github.kristofa.brave.SpanAndEndpoint;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.SpanId;
import com.github.kristofa.brave.TraceFilter;
import com.twitter.zipkin.gen.Span;
import java.util.List;
import java.util.Random;

public abstract class ClientTracer
extends AnnotationSubmitter {
    public static Builder builder() {
        return new AutoValue_ClientTracer.Builder();
    }

    @Override
    abstract SpanAndEndpoint.ClientSpanAndEndpoint spanAndEndpoint();

    abstract Random randomGenerator();

    abstract SpanCollector spanCollector();

    abstract List<TraceFilter> traceFilters();

    public void setClientSent() {
        this.submitAnnotation("cs");
    }

    public void setClientReceived() {
        Span currentSpan = this.spanAndEndpoint().span();
        if (currentSpan != null) {
            this.submitAnnotation("cr");
            this.spanCollector().collect(currentSpan);
            this.spanAndEndpoint().state().setCurrentClientSpan(null);
            this.spanAndEndpoint().state().setCurrentClientServiceName(null);
        }
    }

    public SpanId startNewSpan(String requestName) {
        Boolean sample = this.spanAndEndpoint().state().sample();
        if (Boolean.FALSE.equals(sample)) {
            this.spanAndEndpoint().state().setCurrentClientSpan(null);
            this.spanAndEndpoint().state().setCurrentClientServiceName(null);
            return null;
        }
        SpanId newSpanId = this.getNewSpanId();
        if (sample == null) {
            for (TraceFilter traceFilter : this.traceFilters()) {
                if (traceFilter.trace(newSpanId.getSpanId(), requestName)) continue;
                this.spanAndEndpoint().state().setCurrentClientSpan(null);
                this.spanAndEndpoint().state().setCurrentClientServiceName(null);
                return null;
            }
        }
        Span newSpan = new Span();
        newSpan.setId(newSpanId.getSpanId());
        newSpan.setTrace_id(newSpanId.getTraceId());
        if (newSpanId.getParentSpanId() != null) {
            newSpan.setParent_id(newSpanId.getParentSpanId());
        }
        newSpan.setName(requestName);
        this.spanAndEndpoint().state().setCurrentClientSpan(newSpan);
        return newSpanId;
    }

    public void setCurrentClientServiceName(String serviceName) {
        this.spanAndEndpoint().state().setCurrentClientServiceName(serviceName);
    }

    private SpanId getNewSpanId() {
        Span currentServerSpan = this.spanAndEndpoint().state().getCurrentServerSpan().getSpan();
        long newSpanId = this.randomGenerator().nextLong();
        if (currentServerSpan == null) {
            return SpanId.create(newSpanId, newSpanId, null);
        }
        return SpanId.create(currentServerSpan.getTrace_id(), newSpanId, currentServerSpan.getId());
    }

    ClientTracer() {
    }

    public static abstract class Builder {
        public Builder state(ServerAndClientSpanState state) {
            return this.spanAndEndpoint(SpanAndEndpoint.ClientSpanAndEndpoint.create(state));
        }

        abstract Builder spanAndEndpoint(SpanAndEndpoint.ClientSpanAndEndpoint var1);

        public abstract Builder randomGenerator(Random var1);

        public abstract Builder spanCollector(SpanCollector var1);

        public abstract Builder traceFilters(List<TraceFilter> var1);

        abstract ClientTracer build();
    }
}

