/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.KeyValueAnnotation;
import com.github.kristofa.brave.ServerRequestAdapter;
import com.github.kristofa.brave.ServerTracer;
import com.github.kristofa.brave.SpanId;
import com.github.kristofa.brave.TraceData;
import com.github.kristofa.brave.internal.Util;
import java.util.logging.Logger;

public class ServerRequestInterceptor {
    private static final Logger LOGGER = Logger.getLogger(ServerRequestInterceptor.class.getName());
    private final ServerTracer serverTracer;

    public ServerRequestInterceptor(ServerTracer serverTracer) {
        this.serverTracer = Util.checkNotNull(serverTracer, "Null serverTracer", new Object[0]);
    }

    public void handle(ServerRequestAdapter adapter) {
        this.serverTracer.clearCurrentSpan();
        TraceData traceData = adapter.getTraceData();
        Boolean sample = traceData.getSample();
        if (sample != null && Boolean.FALSE.equals(sample)) {
            this.serverTracer.setStateNoTracing();
            LOGGER.fine("Received indication that we should NOT trace.");
        } else {
            if (traceData.getSpanId() != null) {
                LOGGER.fine("Received span information as part of request.");
                SpanId spanId = traceData.getSpanId();
                this.serverTracer.setStateCurrentTrace(spanId.getTraceId(), spanId.getSpanId(), spanId.getParentSpanId(), adapter.getSpanName());
            } else {
                LOGGER.fine("Received no span state.");
                this.serverTracer.setStateUnknown(adapter.getSpanName());
            }
            this.serverTracer.setServerReceived();
            for (KeyValueAnnotation annotation : adapter.requestAnnotations()) {
                this.serverTracer.submitBinaryAnnotation(annotation.getKey(), annotation.getValue());
            }
        }
    }
}

