/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.InetAddressUtilities;
import com.github.kristofa.brave.ServerAndClientSpanState;
import com.github.kristofa.brave.ServerSpan;
import com.github.kristofa.brave.internal.Util;
import com.twitter.zipkin.gen.Endpoint;
import com.twitter.zipkin.gen.Span;
import java.net.InetAddress;

final class SimpleServerAndClientSpanState
implements ServerAndClientSpanState {
    private Endpoint endpoint;
    private Span currentClientSpan;
    private ServerSpan currentServerSpan;
    private String currentClientServiceName;

    public SimpleServerAndClientSpanState(InetAddress ip, int port, String serviceName) {
        Util.checkNotNull(ip, "ip address must be specified.", new Object[0]);
        Util.checkNotBlank(serviceName, "Service name must be specified.", new Object[0]);
        this.endpoint = new Endpoint(InetAddressUtilities.toInt(ip), (short)port, serviceName);
    }

    @Override
    public ServerSpan getCurrentServerSpan() {
        return this.currentServerSpan;
    }

    @Override
    public void setCurrentServerSpan(ServerSpan span) {
        this.currentServerSpan = span;
    }

    @Override
    public Endpoint getServerEndpoint() {
        return this.endpoint;
    }

    @Override
    public Span getCurrentClientSpan() {
        return this.currentClientSpan;
    }

    @Override
    public Endpoint getClientEndpoint() {
        if (this.currentClientServiceName == null) {
            return this.endpoint;
        }
        Endpoint newEndpoint = new Endpoint(this.endpoint);
        newEndpoint.setService_name(this.currentClientServiceName);
        return newEndpoint;
    }

    @Override
    public void setCurrentClientSpan(Span span) {
        this.currentClientSpan = span;
    }

    @Override
    public void setCurrentClientServiceName(String serviceName) {
        this.currentClientServiceName = serviceName;
    }

    @Override
    public Boolean sample() {
        return this.currentServerSpan.getSample();
    }
}

