/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.InetAddressUtilities;
import com.github.kristofa.brave.ServerAndClientSpanState;
import com.github.kristofa.brave.ServerSpan;
import com.github.kristofa.brave.internal.Util;
import com.twitter.zipkin.gen.Endpoint;
import com.twitter.zipkin.gen.Span;
import java.net.InetAddress;

final class ThreadLocalServerAndClientSpanState
implements ServerAndClientSpanState {
    private static final ThreadLocal<ServerSpan> currentServerSpan = new ThreadLocal<ServerSpan>(){

        @Override
        protected ServerSpan initialValue() {
            return ServerSpan.create(null);
        }
    };
    private static final ThreadLocal<Span> currentClientSpan = new ThreadLocal();
    private static final ThreadLocal<String> currentClientServiceName = new ThreadLocal();
    private final Endpoint endpoint;

    public ThreadLocalServerAndClientSpanState(InetAddress ip, int port, String serviceName) {
        Util.checkNotNull(ip, "ip address must be specified.", new Object[0]);
        Util.checkNotBlank(serviceName, "Service name must be specified.", new Object[0]);
        this.endpoint = new Endpoint(InetAddressUtilities.toInt(ip), (short)port, serviceName);
    }

    @Override
    public ServerSpan getCurrentServerSpan() {
        return currentServerSpan.get();
    }

    @Override
    public Endpoint getServerEndpoint() {
        return this.endpoint;
    }

    @Override
    public void setCurrentServerSpan(ServerSpan span) {
        if (span == null) {
            currentServerSpan.remove();
        } else {
            currentServerSpan.set(span);
        }
    }

    @Override
    public Endpoint getClientEndpoint() {
        String serviceName = currentClientServiceName.get();
        if (serviceName == null) {
            return this.endpoint;
        }
        Endpoint ep = new Endpoint(this.endpoint);
        ep.setService_name(serviceName);
        return ep;
    }

    @Override
    public Span getCurrentClientSpan() {
        return currentClientSpan.get();
    }

    @Override
    public void setCurrentClientSpan(Span span) {
        currentClientSpan.set(span);
    }

    @Override
    public void setCurrentClientServiceName(String serviceName) {
        currentClientServiceName.set(serviceName);
    }

    @Override
    public Boolean sample() {
        return currentServerSpan.get().getSample();
    }
}

