/*
 * Decompiled with CFR 0.152.
 */
package com.naturalness;

import com.naturalness.Event;
import java.util.HashMap;
import java.util.Map;

public class NGramSuccessorModel<T> {
    private final int NULL_PROBABILITY = 0;
    private Map<Event<T>, Integer> successorMap = new HashMap<Event<T>, Integer>();
    private int occurence = 0;

    public double getProbability(Event<T> event) {
        if (event == null) {
            throw new IllegalArgumentException("event cannot be null");
        }
        if (!this.successorMap.containsKey(event)) {
            return 0.0;
        }
        double eventOccurence = this.successorMap.get(event).doubleValue();
        double proba = eventOccurence / (double)this.occurence;
        return proba;
    }

    public void learn(Event<T> event) {
        if (event == null) {
            throw new IllegalArgumentException("event cannot be null");
        }
        if (!this.successorMap.containsKey(event)) {
            this.successorMap.put(event, 1);
        } else {
            int newOccurence = this.successorMap.get(event) + 1;
            this.successorMap.replace(event, newOccurence);
        }
        ++this.occurence;
    }

    public int occurence() {
        return this.occurence;
    }

    public int size() {
        return this.successorMap.size();
    }
}

