/*
 * Decompiled with CFR 0.152.
 */
package com.github.mcheely.maven.requirejs;

import com.github.mcheely.maven.requirejs.MojoErrorReporter;
import com.github.mcheely.maven.requirejs.NodeJsRunner;
import com.github.mcheely.maven.requirejs.OptimizationException;
import com.github.mcheely.maven.requirejs.Optimizer;
import com.github.mcheely.maven.requirejs.RhinoRunner;
import com.github.mcheely.maven.requirejs.Runner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.mozilla.javascript.EvaluatorException;

public class OptimizeMojo
extends AbstractMojo {
    private MavenFileFilter mavenFileFilter;
    private MavenProject project;
    private File buildDirectory;
    protected MavenSession session;
    private File optimizerFile;
    private File configFile;
    private boolean filterConfig;
    private boolean skip;
    private String nodeExecutable;

    public void execute() throws MojoExecutionException {
        Runner runner;
        if (this.skip) {
            this.getLog().info((CharSequence)"Optimization is skipped.");
            return;
        }
        String nodeCommand = this.getNodeJsPath();
        if (nodeCommand != null) {
            this.getLog().info((CharSequence)("Running with Node @ " + nodeCommand));
            runner = new NodeJsRunner(nodeCommand);
        } else {
            this.getLog().info((CharSequence)"Node not detected. Falling back to rhino");
            runner = new RhinoRunner();
        }
        try {
            Optimizer builder = new Optimizer();
            MojoErrorReporter reporter = new MojoErrorReporter(this.getLog(), true);
            if (this.optimizerFile != null) {
                builder.optimize(this.createBuildProfile(), this.optimizerFile, reporter, runner);
            } else {
                builder.optimize(this.createBuildProfile(), reporter, runner);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read r.js", (Exception)e);
        }
        catch (EvaluatorException e) {
            throw new MojoExecutionException("Failed to execute r.js", (Exception)((Object)e));
        }
        catch (OptimizationException e) {
            throw new MojoExecutionException("r.js exited with an error.");
        }
    }

    public Map getPluginContext() {
        return super.getPluginContext();
    }

    private File createBuildProfile() throws MojoExecutionException {
        if (this.filterConfig) {
            File filteredConfig;
            try {
                File profileDir = new File(this.buildDirectory, "requirejs-config/");
                profileDir.mkdirs();
                filteredConfig = new File(profileDir, "filtered-build.js");
                if (!filteredConfig.exists()) {
                    filteredConfig.createNewFile();
                }
                this.mavenFileFilter.copyFile(this.configFile, filteredConfig, true, this.project, new ArrayList(), true, "UTF8", this.session);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating filtered build file.", (Exception)e);
            }
            catch (MavenFilteringException e) {
                throw new MojoExecutionException("Error filtering config file.", (Exception)((Object)e));
            }
            return filteredConfig;
        }
        return this.configFile;
    }

    private String getNodeJsPath() {
        if (this.nodeExecutable != null) {
            return this.nodeExecutable;
        }
        return NodeJsRunner.detectNodeCommand();
    }
}

