/*
 * Decompiled with CFR 0.152.
 */
package com.github.mcheely.maven.requirejs;

import com.github.mcheely.maven.requirejs.ExitStatus;
import com.github.mcheely.maven.requirejs.OptimizationException;
import com.github.mcheely.maven.requirejs.Runner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.codehaus.plexus.util.IOUtil;
import org.mozilla.javascript.ErrorReporter;

public class Optimizer {
    private static final String CLASSPATH_R_JS = "/r.js";

    public void optimize(File buildProfile, ErrorReporter reporter, Runner runner) throws IOException, OptimizationException {
        File optimizerFile = this.getClasspathOptimizerFile();
        this.optimize(buildProfile, optimizerFile, reporter, runner);
    }

    public void optimize(File buildProfile, File optimizerFile, ErrorReporter reporter, Runner runner) throws IOException, OptimizationException {
        String[] args = new String[]{"-o", buildProfile.getAbsolutePath()};
        ExitStatus status = runner.exec(optimizerFile, args, reporter);
        if (!status.success()) {
            throw new OptimizationException("Optimizer returned non-zero exit status.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getClasspathOptimizerFile() throws IOException {
        File optimizerFile = File.createTempFile("build", "js");
        optimizerFile.deleteOnExit();
        FileOutputStream out = null;
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream(CLASSPATH_R_JS);
            out = new FileOutputStream(optimizerFile);
            IOUtil.copy((InputStream)in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((InputStream)in);
        IOUtil.close((OutputStream)out);
        return optimizerFile;
    }
}

