/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.bean.util;

import java.util.List;
import java.util.Map;
import org.meanbean.bean.info.BeanInformation;
import org.meanbean.bean.info.PropertyInformation;
import org.meanbean.bean.util.BeanPopulationException;
import org.meanbean.bean.util.BeanPopulator;
import org.meanbean.bean.util.PropertyInformationFilter;
import org.meanbean.util.ValidationHelper;

public class BasicBeanPopulator
implements BeanPopulator {
    @Override
    public void populate(Object bean, BeanInformation beanInformation, Map<String, Object> values) throws IllegalArgumentException, BeanPopulationException {
        ValidationHelper.ensureExists("bean", "populate bean", bean);
        ValidationHelper.ensureExists("beanInformation", "populate bean", beanInformation);
        ValidationHelper.ensureExists("values", "populate bean", values);
        List<PropertyInformation> writableProperties = PropertyInformationFilter.filter(beanInformation.getProperties(), PropertyInformationFilter.PropertyVisibility.WRITABLE);
        for (PropertyInformation property : writableProperties) {
            String propertyName = property.getName();
            if (!values.containsKey(propertyName)) continue;
            try {
                property.getWriteMethod().invoke(bean, values.get(propertyName));
            }
            catch (Exception e) {
                String message = "Failed to populate property [" + propertyName + "] due to Exception [" + e.getClass().getName() + "]: [" + e.getMessage() + "].";
                throw new BeanPopulationException(message, e);
            }
        }
    }
}

