/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.factories;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.meanbean.factories.FactoryCollection;
import org.meanbean.factories.FactoryCollectionPlugin;
import org.meanbean.lang.Factory;
import org.meanbean.util.RandomValueGenerator;

public class ConcurrentFactoryPlugin
implements FactoryCollectionPlugin {
    @Override
    public void initialize(FactoryCollection factoryCollection, RandomValueGenerator randomValueGenerator) {
        factoryCollection.addFactory(AtomicInteger.class, this.newFactory(randomValueGenerator::nextInt, AtomicInteger::new));
        factoryCollection.addFactory(AtomicLong.class, this.newFactory(randomValueGenerator::nextLong, AtomicLong::new));
        factoryCollection.addFactory(AtomicBoolean.class, () -> new AtomicBoolean(randomValueGenerator.nextBoolean()));
    }

    private <A extends Number, N extends Number> Factory<A> newFactory(Factory<N> factory, Function<N, A> fn) {
        return () -> (Number)fn.apply(factory.create());
    }
}

