/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.factories;

import java.lang.reflect.Type;
import java.util.function.Supplier;
import org.meanbean.factories.NoSuchFactoryException;
import org.meanbean.lang.Factory;
import org.meanbean.util.ServiceDefinition;

public interface FactoryLookup {
    public <T> Factory<T> getFactory(Type var1) throws IllegalArgumentException, NoSuchFactoryException;

    public boolean hasFactory(Type var1) throws IllegalArgumentException;

    default public <T> Factory<T> getFactoryIfAvailable(Type type, Supplier<Factory<T>> fallback) {
        if (this.hasFactory(type)) {
            return this.getFactory(type);
        }
        return fallback.get();
    }

    public static ServiceDefinition<FactoryLookup> getServiceDefinition() {
        return new ServiceDefinition<FactoryLookup>(FactoryLookup.class);
    }

    public static FactoryLookup getInstance() {
        return FactoryLookup.getServiceDefinition().getServiceFactory().getFirst();
    }
}

