/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.factories;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.meanbean.factories.FactoryCollection;
import org.meanbean.factories.FactoryCollectionPlugin;
import org.meanbean.factories.FactoryLookup;
import org.meanbean.factories.NoSuchFactoryException;
import org.meanbean.lang.Factory;
import org.meanbean.util.Order;
import org.meanbean.util.RandomValueGenerator;
import org.meanbean.util.ValidationHelper;

@Order(value=8000)
public final class FactoryRepository
implements FactoryCollection {
    private final Map<Type, Factory<?>> factories = new ConcurrentHashMap();
    private final RandomValueGenerator randomValueGenerator = RandomValueGenerator.getInstance();

    public FactoryRepository() throws IllegalArgumentException {
        this.initialize();
    }

    public RandomValueGenerator getRandomValueGenerator() {
        return this.randomValueGenerator;
    }

    private void initialize() {
        FactoryCollectionPlugin.getInstances().forEach(plugin -> plugin.initialize(this, this.randomValueGenerator));
    }

    @Override
    public void addFactory(Class<?> clazz, Factory<?> factory) throws IllegalArgumentException {
        ValidationHelper.ensureExists("clazz", "add Factory", clazz);
        ValidationHelper.ensureExists("factory", "add Factory", factory);
        this.factories.put(clazz, factory);
    }

    @Override
    public void addFactoryLookup(FactoryLookup factoryLookup) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Factory<T> getFactory(Type type) throws IllegalArgumentException, NoSuchFactoryException {
        ValidationHelper.ensureExists("type", "get Factory", type);
        Factory<?> factory = this.factories.get(type);
        if (factory == null) {
            String message = "Failed to find a Factory registered against [" + type + "] in the Repository.";
            throw new NoSuchFactoryException(message);
        }
        return factory;
    }

    @Override
    public boolean hasFactory(Type type) throws IllegalArgumentException {
        ValidationHelper.ensureExists("type", "check collection for Factory", type);
        return this.factories.containsKey(type);
    }

    Map<Type, Factory<?>> getFactories() {
        return this.factories;
    }
}

