/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.meanbean.lang.Factory;
import org.meanbean.test.Warning;
import org.meanbean.util.ValidationHelper;

public class Configuration {
    private Integer iterations;
    private Set<String> ignoredProperties;
    private Map<String, Factory<?>> overrideFactories;
    private List<String> equalsInsignificantProperties = new ArrayList<String>();
    private Set<Warning> suppressedWarnings = EnumSet.noneOf(Warning.class);

    Configuration(Integer iterations, Set<String> ignoredProperties, Map<String, Factory<?>> overrideFactories, Set<Warning> suppressedWarnings) {
        this.iterations = iterations;
        this.ignoredProperties = ignoredProperties;
        this.overrideFactories = overrideFactories;
        this.suppressedWarnings = suppressedWarnings;
    }

    static Configuration defaultConfiguration() {
        return new Configuration(100, Collections.emptySet(), Collections.emptyMap(), EnumSet.noneOf(Warning.class));
    }

    static Configuration defaultMutableConfiguration(int iterations) {
        return new Configuration(iterations, new HashSet<String>(), new HashMap(), EnumSet.noneOf(Warning.class));
    }

    static Function<Class<?>, Configuration> customConfigurationProvider(Map<Class<?>, Configuration> customConfigurations, Configuration defaultConfiguration) {
        return beanClass -> {
            ValidationHelper.ensureExists("beanClass", "check for custom configuration", beanClass);
            return customConfigurations.getOrDefault(beanClass, defaultConfiguration);
        };
    }

    static Function<Class<?>, Configuration> defaultConfigurationProvider() {
        return Configuration.customConfigurationProvider(Collections.emptyMap(), Configuration.defaultConfiguration());
    }

    public boolean hasIterationsOverride() {
        return this.getIterations() != null;
    }

    public Integer getIterations() {
        return this.iterations;
    }

    public boolean isIgnoredProperty(String property) throws IllegalArgumentException {
        ValidationHelper.ensureExists("property", "check whether a property is ignored", property);
        return this.ignoredProperties.contains(property);
    }

    public boolean isSuppressedWarning(Warning warning) {
        return this.suppressedWarnings.contains((Object)warning);
    }

    void suppress(Warning warning) {
        this.suppressedWarnings.add(warning);
    }

    public boolean hasOverrideFactory(String property) throws IllegalArgumentException {
        ValidationHelper.ensureExists("property", "check whether a property has an override Factory", property);
        return this.overrideFactories.containsKey(property);
    }

    public Factory<? extends Object> getOverrideFactory(String property) throws IllegalArgumentException {
        ValidationHelper.ensureExists("property", "get override Factory", property);
        return this.overrideFactories.get(property);
    }

    Set<String> getIgnoredProperties() {
        return this.ignoredProperties;
    }

    void setIgnoredProperties(Set<String> ignoredProperties) {
        this.ignoredProperties = ignoredProperties;
    }

    Map<String, Factory<?>> getOverrideFactories() {
        return this.overrideFactories;
    }

    void setOverrideFactories(Map<String, Factory<?>> overrideFactories) {
        this.overrideFactories = overrideFactories;
    }

    void setIterations(Integer iterations) {
        ValidationHelper.ensure(iterations >= 1, "Iterations must be at least 1.");
        this.iterations = iterations;
    }

    List<String> getEqualsInsignificantProperties() {
        return this.equalsInsignificantProperties;
    }

    void setEqualsInsignificantProperties(List<String> equalsInsignificantProperties) {
        this.equalsInsignificantProperties = equalsInsignificantProperties;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Configuration[");
        str.append("iterations=").append(this.iterations).append(",");
        str.append("ignoredProperties=").append(this.ignoredProperties).append(",");
        str.append("overrideFactories=").append(this.overrideFactories);
        str.append("]");
        return str.toString();
    }
}

