/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.test.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.meanbean.bean.info.PropertyInformation;
import org.meanbean.logging.$Logger;
import org.meanbean.logging.$LoggerFactory;
import org.meanbean.test.BeanTestException;
import org.meanbean.test.internal.EqualityTest;
import org.meanbean.test.internal.SideEffectDetector;
import org.meanbean.util.AssertionUtils;

public class SideEffectDetectorImpl
implements SideEffectDetector {
    private static final $Logger logger = $LoggerFactory.getLogger(SideEffectDetectorImpl.class);
    private Object bean;
    private List<PropertyInformation> readableWritableProperties;
    private Map<PropertyInformation, EqualityTest> equalityTestsByProperty = new HashMap<PropertyInformation, EqualityTest>();
    private PropertyInformation propertyUnderTest;
    private Map<String, Object> beforeValues;

    @Override
    public List<PropertyInformation> init(Object bean, List<PropertyInformation> readableWritableProperties) {
        this.bean = bean;
        this.readableWritableProperties = readableWritableProperties;
        Collections.shuffle(readableWritableProperties);
        return readableWritableProperties;
    }

    @Override
    public void beforeTestProperty(PropertyInformation property, EqualityTest equalityTest) {
        this.propertyUnderTest = property;
        this.equalityTestsByProperty.put(property, equalityTest);
        this.beforeValues = this.saveValues();
    }

    @Override
    public void detectAfterTestProperty() {
        Map<String, Object> afterValues = this.saveValues();
        this.beforeValues.remove(this.propertyUnderTest.getName());
        afterValues.remove(this.propertyUnderTest.getName());
        for (Map.Entry<String, Object> beforeEntry : this.beforeValues.entrySet()) {
            String otherProperty = beforeEntry.getKey();
            Object beforeValue = beforeEntry.getValue();
            Object afterValue = afterValues.get(otherProperty);
            EqualityTest equalityTest = this.equalityTestsByProperty.getOrDefault(otherProperty, EqualityTest.LOGICAL);
            if (beforeValue == null || equalityTest.test(beforeValue, afterValue)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Side-effect detected.\nBefore={}\nAfter={}", this.beforeValues, afterValues);
            }
            String message = String.format("Property [%s] appears to have a side-effect on another property [%s]", this.propertyUnderTest.getName(), otherProperty);
            AssertionUtils.fail(message);
        }
    }

    private Map<String, Object> saveValues() {
        TreeMap<String, Object> values = new TreeMap<String, Object>();
        for (PropertyInformation property : this.readableWritableProperties) {
            try {
                Object value = property.getReadMethod().invoke(this.bean, new Object[0]);
                values.put(property.getName(), value);
            }
            catch (Exception e) {
                String propertyName = property.getName();
                String message = "Failed to test property [" + propertyName + "] due to Exception [" + e.getClass().getName() + "]: [" + e.getMessage() + "].";
                throw new BeanTestException(message, e);
            }
        }
        return values;
    }
}

