/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.stream.Stream;
import org.meanbean.util.ServiceFactory;

public final class ServiceLoader<T> {
    private static final String SERVICE_PREFIX = "META-INF/services/";
    private final Class<? extends T> service;
    private final Class<?>[] argumentTypes;
    private final ClassLoader classLoader;

    public ServiceLoader(Class<? extends T> service, Class<?> ... argumentTypes) {
        this.service = service;
        this.argumentTypes = argumentTypes;
        this.classLoader = Stream.of(Thread.currentThread().getContextClassLoader(), this.getClass().getClassLoader()).filter(Objects::nonNull).findFirst().orElse(ClassLoader.getSystemClassLoader());
    }

    public List<T> createAll(Object ... arguments) {
        try {
            Collection<String> classNames = ServiceLoader.findClassNames(this.classLoader, this.service);
            ArrayList<T> services = new ArrayList<T>(classNames.size());
            for (String className : classNames) {
                services.add(this.createInstance(className, arguments));
            }
            Collections.sort(services, ServiceFactory.getComparator());
            return services;
        }
        catch (Exception ex) {
            throw new ServiceConfigurationError("Cannot create service instance for " + this.service.getName(), ex);
        }
    }

    private static <T> Collection<String> findClassNames(ClassLoader classLoader, Class<? extends T> service) throws IOException {
        String name = SERVICE_PREFIX + service.getName();
        Enumeration<URL> urls = classLoader.getResources(name);
        LinkedHashSet<String> classNames = new LinkedHashSet<String>();
        for (URL url : Collections.list(urls)) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
            Throwable throwable = null;
            try {
                reader.lines().map(String::trim).filter(line -> !line.isEmpty()).filter(line -> line.charAt(0) != '#').forEach(classNames::add);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
        return classNames;
    }

    private T createInstance(String className, Object ... arguments) throws Exception {
        Class<?> implementation = Class.forName(className, false, this.classLoader);
        Constructor<?> constructor = implementation.getDeclaredConstructor(this.argumentTypes);
        Object newInstance = constructor.newInstance(arguments);
        return this.service.cast(newInstance);
    }
}

