/*
 * Decompiled with CFR 0.152.
 */
package com.github.meanbeanlib.mirror;

import java.util.ArrayList;

abstract class Utility {
    private static ThreadLocal<Integer> consumed_chars = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    Utility() {
    }

    private static int unwrap(ThreadLocal<Integer> tl) {
        return tl.get();
    }

    private static void wrap(ThreadLocal<Integer> tl, int value) {
        tl.set(value);
    }

    public static String compactClassName(String str, boolean chopit) {
        return Utility.compactClassName(str, "java.lang.", chopit);
    }

    public static String compactClassName(String str, String prefix, boolean chopit) {
        int len = prefix.length();
        str = str.replace('/', '.');
        if (chopit && str.startsWith(prefix) && str.substring(len).indexOf(46) == -1) {
            str = str.substring(len);
        }
        return str;
    }

    public static String[] methodSignatureArgumentTypes(String signature, boolean chopit) throws IllegalArgumentException {
        ArrayList<String> vec = new ArrayList<String>();
        try {
            int index = signature.indexOf(40) + 1;
            if (index <= 0) {
                throw new IllegalArgumentException("Invalid method signature: " + signature);
            }
            while (signature.charAt(index) != ')') {
                vec.add(Utility.typeSignatureToString(signature.substring(index), chopit));
                index += Utility.unwrap(consumed_chars);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid method signature: " + signature, e);
        }
        return vec.toArray(new String[vec.size()]);
    }

    public static String typeSignatureToString(String signature, boolean chopit) throws IllegalArgumentException {
        Utility.wrap(consumed_chars, 1);
        try {
            switch (signature.charAt(0)) {
                case 'B': {
                    return "byte";
                }
                case 'C': {
                    return "char";
                }
                case 'D': {
                    return "double";
                }
                case 'F': {
                    return "float";
                }
                case 'I': {
                    return "int";
                }
                case 'J': {
                    return "long";
                }
                case 'T': {
                    int index = signature.indexOf(59);
                    if (index < 0) {
                        throw new IllegalArgumentException("Invalid type variable signature: " + signature);
                    }
                    Utility.wrap(consumed_chars, index + 1);
                    return Utility.compactClassName(signature.substring(1, index), chopit);
                }
                case 'L': {
                    int fromIndex = signature.indexOf(60);
                    if (fromIndex < 0) {
                        fromIndex = 0;
                    } else if ((fromIndex = signature.indexOf(62, fromIndex)) < 0) {
                        throw new IllegalArgumentException("Invalid signature: " + signature);
                    }
                    int index = signature.indexOf(59, fromIndex);
                    if (index < 0) {
                        throw new IllegalArgumentException("Invalid signature: " + signature);
                    }
                    int bracketIndex = signature.substring(0, index).indexOf(60);
                    if (bracketIndex < 0) {
                        Utility.wrap(consumed_chars, index + 1);
                        return Utility.compactClassName(signature.substring(1, index), chopit);
                    }
                    fromIndex = signature.indexOf(59);
                    if (fromIndex < 0) {
                        throw new IllegalArgumentException("Invalid signature: " + signature);
                    }
                    if (fromIndex < bracketIndex) {
                        Utility.wrap(consumed_chars, fromIndex + 1);
                        return Utility.compactClassName(signature.substring(1, fromIndex), chopit);
                    }
                    StringBuilder type = new StringBuilder(Utility.compactClassName(signature.substring(1, bracketIndex), chopit)).append("<");
                    int consumed_chars = bracketIndex + 1;
                    if (signature.charAt(consumed_chars) == '+') {
                        type.append("? extends ");
                        ++consumed_chars;
                    } else if (signature.charAt(consumed_chars) == '-') {
                        type.append("? super ");
                        ++consumed_chars;
                    }
                    if (signature.charAt(consumed_chars) == '*') {
                        type.append("?");
                        ++consumed_chars;
                    } else {
                        type.append(Utility.typeSignatureToString(signature.substring(consumed_chars), chopit));
                        consumed_chars = Utility.unwrap(Utility.consumed_chars) + consumed_chars;
                        Utility.wrap(Utility.consumed_chars, consumed_chars);
                    }
                    while (signature.charAt(consumed_chars) != '>') {
                        type.append(", ");
                        if (signature.charAt(consumed_chars) == '+') {
                            type.append("? extends ");
                            ++consumed_chars;
                        } else if (signature.charAt(consumed_chars) == '-') {
                            type.append("? super ");
                            ++consumed_chars;
                        }
                        if (signature.charAt(consumed_chars) == '*') {
                            type.append("?");
                            ++consumed_chars;
                            continue;
                        }
                        type.append(Utility.typeSignatureToString(signature.substring(consumed_chars), chopit));
                        consumed_chars = Utility.unwrap(Utility.consumed_chars) + consumed_chars;
                        Utility.wrap(Utility.consumed_chars, consumed_chars);
                    }
                    type.append(">");
                    if (signature.charAt(++consumed_chars) == '.') {
                        type.append(".");
                        type.append(Utility.typeSignatureToString("L" + signature.substring(consumed_chars + 1), chopit));
                        consumed_chars = Utility.unwrap(Utility.consumed_chars) + consumed_chars;
                        Utility.wrap(Utility.consumed_chars, consumed_chars);
                        return type.toString();
                    }
                    if (signature.charAt(consumed_chars) != ';') {
                        throw new IllegalArgumentException("Invalid signature: " + signature);
                    }
                    Utility.wrap(Utility.consumed_chars, consumed_chars + 1);
                    return type.toString();
                }
                case 'S': {
                    return "short";
                }
                case 'Z': {
                    return "boolean";
                }
                case '[': {
                    StringBuilder brackets = new StringBuilder();
                    int n = 0;
                    while (signature.charAt(n) == '[') {
                        brackets.append("[]");
                        ++n;
                    }
                    int consumed_chars = n;
                    String type = Utility.typeSignatureToString(signature.substring(n), chopit);
                    int _temp = Utility.unwrap(Utility.consumed_chars) + consumed_chars;
                    Utility.wrap(Utility.consumed_chars, _temp);
                    return type + brackets.toString();
                }
                case 'V': {
                    return "void";
                }
            }
            throw new IllegalArgumentException("Invalid signature: `" + signature + "'");
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid signature: " + signature, e);
        }
    }
}

