/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.core.handlers;

import com.thebuzzmedia.exiftool.Tag;
import com.thebuzzmedia.exiftool.core.handlers.StopHandler;
import com.thebuzzmedia.exiftool.core.handlers.TagHandler;
import com.thebuzzmedia.exiftool.logs.Logger;
import com.thebuzzmedia.exiftool.logs.LoggerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class BaseTagHandler
implements TagHandler {
    private static final Logger log = LoggerFactory.getLogger(BaseTagHandler.class);
    private static final Pattern TAG_VALUE_PATTERN = Pattern.compile(": ");
    private final Map<Tag, String> tags = new HashMap<Tag, String>();

    @Override
    public boolean readLine(String line) {
        if (!StopHandler.stopHandler().readLine(line)) {
            return false;
        }
        String[] pair = TAG_VALUE_PATTERN.split(line, 2);
        if (pair != null && pair.length == 2) {
            String name = pair[0];
            String value = pair[1];
            Tag tag = this.toTag(name);
            if (tag != null) {
                this.tags.put(tag, value);
                log.debug("Read Tag [name={}, value={}]", tag, value);
            } else {
                log.debug("Unable to read Tag: {}", line);
            }
        } else {
            log.warn("Skipped line: {}", line);
        }
        return true;
    }

    abstract Tag toTag(String var1);

    @Override
    public Map<Tag, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    @Override
    public int size() {
        return this.tags.size();
    }
}

