/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.exceptions;

import com.thebuzzmedia.exiftool.Version;
import com.thebuzzmedia.exiftool.exceptions.AbstractExifException;

public class UnsupportedFeatureException
extends AbstractExifException {
    private final Version version;
    private final String path;

    public UnsupportedFeatureException(String path, Version version) {
        super(UnsupportedFeatureException.message(path, version));
        this.version = version;
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public Version getVersion() {
        return this.version;
    }

    private static String message(String path, Version version) {
        String msg = "Use of feature requires version %s or higher of the native ExifTool program. The version of ExifTool referenced by the path '%s' is not high enough. You can either upgrade the install of ExifTool or avoid using this feature to workaround this exception.";
        return String.format(msg, version, path);
    }
}

