/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.logs;

import com.thebuzzmedia.exiftool.logs.LogUtils;
import com.thebuzzmedia.exiftool.logs.Logger;

class DefaultLogger
implements Logger {
    private final Level level;

    DefaultLogger(boolean debug) {
        this.level = debug ? Level.TRACE : Level.INFO;
    }

    @Override
    public void trace(String message) {
        this.print(Level.TRACE, message);
    }

    @Override
    public void trace(String message, Object p1) {
        this.print(Level.TRACE, message, p1);
    }

    @Override
    public void trace(String message, Object p1, Object p2) {
        this.print(Level.TRACE, message, p1, p2);
    }

    @Override
    public void info(String message) {
        this.print(Level.INFO, message);
    }

    @Override
    public void info(String message, Object p1) {
        this.print(Level.INFO, message, p1);
    }

    @Override
    public void info(String message, Object p1, Object p2) {
        this.print(Level.INFO, message, p1, p2);
    }

    @Override
    public void debug(String message) {
        this.print(Level.DEBUG, message);
    }

    @Override
    public void debug(String message, Object p1) {
        this.print(Level.DEBUG, message, p1);
    }

    @Override
    public void debug(String message, Object p1, Object p2) {
        this.print(Level.DEBUG, message, p1, p2);
    }

    @Override
    public void warn(String message) {
        this.print(Level.WARN, message);
    }

    @Override
    public void warn(String message, Throwable ex) {
        this.printThrowable(Level.WARN, message, ex);
    }

    @Override
    public void warn(String message, Object p1) {
        this.print(Level.WARN, message, p1);
    }

    @Override
    public void warn(String message, Object p1, Object p2) {
        this.print(Level.WARN, message, p1, p2);
    }

    @Override
    public void error(String message) {
        this.print(Level.ERROR, message);
    }

    @Override
    public void error(String message, Object p1) {
        this.print(Level.ERROR, message, p1);
    }

    @Override
    public void error(String message, Object p1, Object p2) {
        this.print(Level.ERROR, message, p1, p2);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    @Override
    public void error(String message, Throwable ex) {
        this.printThrowable(Level.ERROR, message, ex);
    }

    private boolean isEnabled(Level level) {
        return this.level.compareTo(level) <= 0;
    }

    private void print(Level level, String message) {
        if (this.isEnabled(level)) {
            System.out.println(DefaultLogger.logPrefix(level) + message);
        }
    }

    private void print(Level level, String message, Object p1) {
        if (this.isEnabled(level)) {
            System.out.println(DefaultLogger.logPrefix(level) + String.format(LogUtils.fromSlf4jStyle(message), p1));
        }
    }

    private void print(Level level, String message, Object p1, Object p2) {
        if (this.isEnabled(level)) {
            System.out.println(DefaultLogger.logPrefix(level) + String.format(LogUtils.fromSlf4jStyle(message), p1, p2));
        }
    }

    private void printThrowable(Level level, String message, Throwable ex) {
        if (this.isEnabled(level)) {
            System.out.println(DefaultLogger.logPrefix(level) + message);
            System.out.println(LogUtils.getStackTrace(ex));
        }
    }

    private static String logPrefix(Level level) {
        return "[" + (Object)((Object)level) + "] [exiftool] ";
    }

    private static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

