/*
 * Decompiled with CFR 0.152.
 */
package com.github.reinert.jjschema;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.reinert.jjschema.Attributes;
import com.github.reinert.jjschema.ManagedReference;
import com.github.reinert.jjschema.Nullable;
import com.github.reinert.jjschema.SchemaIgnore;
import com.github.reinert.jjschema.SimpleTypeMappings;
import com.github.reinert.jjschema.exception.TypeException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Deprecated
public abstract class JsonSchemaGenerator {
    private static final String TAG_PROPERTIES = "properties";
    private static final String TAG_REQUIRED = "required";
    private static final String TAG_TYPE = "type";
    private static final String TAG_ARRAY = "array";
    final ObjectMapper mapper = new ObjectMapper();
    boolean autoPutVersion = true;
    boolean sortProperties = true;
    boolean processFieldsOnly = false;
    boolean processAnnotatedOnly = false;
    private Set<ManagedReference> forwardReferences;
    private Set<ManagedReference> backReferences;

    protected JsonSchemaGenerator() {
    }

    Set<ManagedReference> getForwardReferences() {
        if (this.forwardReferences == null) {
            this.forwardReferences = new LinkedHashSet<ManagedReference>();
        }
        return this.forwardReferences;
    }

    <T> void pushForwardReference(ManagedReference forwardReference) {
        this.getForwardReferences().add(forwardReference);
    }

    <T> boolean isForwardReferencePiled(ManagedReference forwardReference) {
        return this.getForwardReferences().contains(forwardReference);
    }

    <T> boolean pullForwardReference(ManagedReference forwardReference) {
        return this.getForwardReferences().remove(forwardReference);
    }

    Set<ManagedReference> getBackwardReferences() {
        if (this.backReferences == null) {
            this.backReferences = new LinkedHashSet<ManagedReference>();
        }
        return this.backReferences;
    }

    <T> void pushBackwardReference(ManagedReference backReference) {
        this.getBackwardReferences().add(backReference);
    }

    <T> boolean isBackwardReferencePiled(ManagedReference backReference) {
        return this.getBackwardReferences().contains(backReference);
    }

    <T> boolean pullBackwardReference(ManagedReference backReference) {
        return this.getBackwardReferences().remove(backReference);
    }

    protected ObjectNode createRefSchema(String ref) {
        return this.createInstance().put("$ref", ref);
    }

    protected abstract void processSchemaProperty(ObjectNode var1, Attributes var2);

    protected ObjectNode createInstance() {
        return this.mapper.createObjectNode();
    }

    public boolean isAutoPutVersion() {
        return this.autoPutVersion;
    }

    public JsonSchemaGenerator setAutoPutVersion(boolean autoPutVersion) {
        this.autoPutVersion = autoPutVersion;
        return this;
    }

    public <T> ObjectNode generateSchema(Class<T> type) throws TypeException {
        ObjectNode schema = this.createInstance();
        schema = this.checkAndProcessType(type, schema);
        return schema;
    }

    protected <T> ObjectNode checkAndProcessType(Class<T> type, ObjectNode schema) throws TypeException {
        String s = SimpleTypeMappings.forClass(type);
        if (s != null) {
            schema.put(TAG_TYPE, s);
        } else if (Iterable.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type)) {
            this.checkAndProcessCollection(type, schema);
        } else if (type == Void.class || type == Void.TYPE) {
            schema = null;
        } else if (type.isEnum()) {
            this.processEnum(type, schema);
        } else {
            schema = this.processCustomType(type, schema);
        }
        return schema;
    }

    protected <T> ObjectNode processCustomType(Class<T> type, ObjectNode schema) throws TypeException {
        schema.put(TAG_TYPE, "object");
        this.processRootAttributes(type, schema);
        if (this.processFieldsOnly) {
            this.processFields(type, schema);
        } else {
            this.processProperties(type, schema);
        }
        schema = this.mergeWithParent(type, schema);
        return schema;
    }

    private <T> void checkAndProcessCollection(Class<T> type, ObjectNode schema) throws TypeException {
        if (AbstractCollection.class.isAssignableFrom(type)) {
            schema.put(TAG_TYPE, TAG_ARRAY);
        } else {
            this.processRootAttributes(type, schema);
            this.processCustomCollection(type, schema);
        }
    }

    private <T> void processCustomCollection(Class<T> type, ObjectNode schema) throws TypeException {
        schema.put(TAG_TYPE, TAG_ARRAY);
        Field field = type.getDeclaredFields()[0];
        ParameterizedType genericType = (ParameterizedType)field.getGenericType();
        Class genericClass = (Class)genericType.getActualTypeArguments()[0];
        ObjectNode itemsSchema = this.generateSchema(genericClass);
        itemsSchema.remove("$schema");
        schema.put("items", (JsonNode)itemsSchema);
    }

    private <T> void processEnum(Class<T> type, ObjectNode schema) {
        ArrayNode enumArray = schema.putArray("enum");
        for (T constant : type.getEnumConstants()) {
            String value = constant.toString();
            try {
                Long integer = Long.parseLong(value);
                enumArray.add(integer);
            }
            catch (NumberFormatException e) {
                try {
                    BigDecimal number = new BigDecimal(value);
                    enumArray.add(number);
                }
                catch (NumberFormatException e1) {
                    enumArray.add(value);
                }
            }
        }
    }

    private void processPropertyCollection(Method method, Field field, ObjectNode schema) throws TypeException {
        schema.put(TAG_TYPE, TAG_ARRAY);
        Class genericClass = null;
        if (method != null) {
            Type methodType = method.getGenericReturnType();
            if (!ParameterizedType.class.isAssignableFrom(methodType.getClass())) {
                throw new TypeException("Collection property must be parameterized: " + method.getName());
            }
            ParameterizedType genericType = (ParameterizedType)methodType;
            genericClass = (Class)genericType.getActualTypeArguments()[0];
        } else {
            genericClass = field.getClass();
        }
        schema.put("items", (JsonNode)this.generateSchema(genericClass));
    }

    protected <T> void processRootAttributes(Class<T> type, ObjectNode schema) {
        Attributes sProp = type.getAnnotation(Attributes.class);
        if (sProp != null) {
            this.processSchemaProperty(schema, sProp);
        }
    }

    protected <T> void processProperties(Class<T> type, ObjectNode schema) throws TypeException {
        HashMap<Method, Field> props = this.findProperties(type);
        for (Map.Entry<Method, Field> entry : props.entrySet()) {
            Field field = entry.getValue();
            Method method = entry.getKey();
            ObjectNode prop = this.generatePropertySchema(type, method, field);
            if (prop == null || field == null) continue;
            this.addPropertyToSchema(schema, field, method, prop);
        }
    }

    protected <T> void processFields(Class<T> type, ObjectNode schema) throws TypeException {
        List<Field> props = this.findFields(type);
        for (Field field : props) {
            ObjectNode prop = this.generatePropertySchema(type, null, field);
            if (prop == null || field == null) continue;
            this.addPropertyToSchema(schema, field, null, prop);
        }
    }

    protected <T> ObjectNode generatePropertySchema(Class<T> type, Method method, Field field) throws TypeException {
        Nullable nullable;
        JsonBackReference backRefAnn;
        Class<Object> returnType = method != null ? method.getReturnType() : field.getType();
        AccessibleObject propertyReflection = field != null ? field : method;
        SchemaIgnore ignoreAnn = propertyReflection.getAnnotation(SchemaIgnore.class);
        if (ignoreAnn != null) {
            return null;
        }
        ObjectNode schema = this.createInstance();
        JsonManagedReference refAnn = propertyReflection.getAnnotation(JsonManagedReference.class);
        if (refAnn != null) {
            Class<Object> genericClass;
            if (Collection.class.isAssignableFrom(returnType)) {
                if (method != null) {
                    ParameterizedType genericType = (ParameterizedType)method.getGenericReturnType();
                    genericClass = (Class<Object>)genericType.getActualTypeArguments()[0];
                } else {
                    genericClass = field.getClass();
                }
                Class<Object> collectionClass = returnType;
            } else {
                genericClass = returnType;
            }
            ManagedReference forwardReference = new ManagedReference(type, refAnn.value(), genericClass);
            if (!this.isForwardReferencePiled(forwardReference)) {
                this.pushForwardReference(forwardReference);
            } else {
                this.pullForwardReference(forwardReference);
                this.pullBackwardReference(forwardReference);
                return this.createRefSchema("#");
            }
        }
        if ((backRefAnn = propertyReflection.getAnnotation(JsonBackReference.class)) != null) {
            Class<Object> genericClass;
            if (Collection.class.isAssignableFrom(returnType)) {
                ParameterizedType genericType = (ParameterizedType)method.getGenericReturnType();
                genericClass = (Class)genericType.getActualTypeArguments()[0];
                Class<Object> collectionClass = returnType;
            } else {
                genericClass = returnType;
            }
            ManagedReference backReference = new ManagedReference(genericClass, backRefAnn.value(), type);
            if (this.isForwardReferencePiled(backReference) && !this.isBackwardReferencePiled(backReference)) {
                this.pushBackwardReference(backReference);
            } else {
                return null;
            }
        }
        if (Collection.class.isAssignableFrom(returnType)) {
            this.processPropertyCollection(method, field, schema);
        } else {
            schema = this.generateSchema(returnType);
        }
        Attributes attrs = propertyReflection.getAnnotation(Attributes.class);
        if (attrs != null) {
            this.processSchemaProperty(schema, attrs);
            schema.remove("$schema");
        }
        if ((nullable = propertyReflection.getAnnotation(Nullable.class)) != null) {
            if (returnType.isEnum()) {
                ((ArrayNode)schema.get("enum")).add("null");
            } else {
                String oldType = schema.get(TAG_TYPE).asText();
                ArrayNode typeArray = schema.putArray(TAG_TYPE);
                typeArray.add(oldType);
                typeArray.add("null");
            }
        }
        return schema;
    }

    private void addPropertyToSchema(ObjectNode schema, Field field, Method method, ObjectNode prop) {
        String name = this.getPropertyName(field, method);
        if (prop.has("selfRequired")) {
            ArrayNode requiredNode = !schema.has(TAG_REQUIRED) ? schema.putArray(TAG_REQUIRED) : (ArrayNode)schema.get(TAG_REQUIRED);
            requiredNode.add(name);
            prop.remove("selfRequired");
        }
        if (!schema.has(TAG_PROPERTIES)) {
            schema.putObject(TAG_PROPERTIES);
        }
        ((ObjectNode)schema.get(TAG_PROPERTIES)).put(name, (JsonNode)prop);
    }

    private String getPropertyName(Field field, Method method) {
        return field == null ? this.firstToLowCase(method.getName().replace("get", "")) : field.getName();
    }

    protected <T> ObjectNode mergeWithParent(Class<T> type, ObjectNode schema) throws TypeException {
        Class<T> superclass = type.getSuperclass();
        if (superclass != null && superclass != Object.class) {
            ObjectNode parentSchema = this.generateSchema(superclass);
            schema = this.mergeSchema(parentSchema, schema, false);
        }
        return schema;
    }

    protected ObjectNode mergeSchema(ObjectNode parent, ObjectNode child, boolean overwriteChildProperties) {
        block6: {
            Iterator namesIterator;
            block5: {
                namesIterator = child.fieldNames();
                if (!overwriteChildProperties) break block5;
                while (namesIterator.hasNext()) {
                    String propertyName = (String)namesIterator.next();
                    this.overwriteProperty(parent, child, propertyName);
                }
                break block6;
            }
            while (namesIterator.hasNext()) {
                String propertyName = (String)namesIterator.next();
                if (TAG_PROPERTIES.equals(propertyName)) continue;
                this.overwriteProperty(parent, child, propertyName);
            }
            ObjectNode properties = (ObjectNode)child.get(TAG_PROPERTIES);
            if (properties == null) break block6;
            if (parent.get(TAG_PROPERTIES) == null) {
                parent.putObject(TAG_PROPERTIES);
            }
            Iterator it = properties.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String pName = (String)entry.getKey();
                ObjectNode pSchema = (ObjectNode)entry.getValue();
                ObjectNode actualSchema = (ObjectNode)parent.get(TAG_PROPERTIES).get(pName);
                if (actualSchema != null) {
                    this.mergeSchema(pSchema, actualSchema, false);
                }
                ((ObjectNode)parent.get(TAG_PROPERTIES)).put(pName, (JsonNode)pSchema);
            }
        }
        return parent;
    }

    protected void overwriteProperty(ObjectNode parent, ObjectNode child, String propertyName) {
        if (child.has(propertyName)) {
            parent.put(propertyName, child.get(propertyName));
        }
    }

    private <T> HashMap<Method, Field> findProperties(Class<T> type) {
        Field[] fields = type.getDeclaredFields();
        Method[] methods = type.getMethods();
        if (this.sortProperties) {
            Arrays.sort(methods, new Comparator<Method>(){

                @Override
                public int compare(Method m1, Method m2) {
                    return m1.getName().compareTo(m2.getName());
                }
            });
        }
        LinkedHashMap<Method, Field> props = new LinkedHashMap<Method, Field>();
        for (Method method : methods) {
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass.equals(Object.class) || Collection.class.isAssignableFrom(declaringClass) || !this.isGetter(method)) continue;
            boolean hasField = false;
            for (Field field : fields) {
                int fieldModifiers = field.getModifiers();
                if (field.isSynthetic() || field.isEnumConstant() || Modifier.isStatic(fieldModifiers) || Modifier.isTransient(fieldModifiers)) continue;
                String name = this.getNameFromGetter(method);
                Attributes attribs = field.getAnnotation(Attributes.class);
                boolean process = true;
                if (this.processAnnotatedOnly && attribs == null) {
                    process = false;
                }
                if (!process || !field.getName().equalsIgnoreCase(name)) continue;
                props.put(method, field);
                hasField = true;
                break;
            }
            if (hasField) continue;
            props.put(method, null);
        }
        return props;
    }

    private <T> List<Field> findFields(Class<T> type) {
        Field[] fields = type.getDeclaredFields();
        if (this.sortProperties) {
            Arrays.sort(fields, new Comparator<Field>(){

                @Override
                public int compare(Field m1, Field m2) {
                    return m1.getName().compareTo(m2.getName());
                }
            });
        }
        ArrayList<Field> props = new ArrayList<Field>();
        for (Field field : fields) {
            Attributes attrs;
            Class<?> declaringClass = field.getDeclaringClass();
            int fieldModifiers = field.getModifiers();
            if (field.isSynthetic() || field.isEnumConstant() || Modifier.isStatic(fieldModifiers) || Modifier.isTransient(fieldModifiers) || declaringClass.equals(Object.class) || Collection.class.isAssignableFrom(declaringClass)) continue;
            String name = field.getName();
            if (!field.getName().equalsIgnoreCase(name) || (attrs = field.getAnnotation(Attributes.class)) == null && this.processAnnotatedOnly) continue;
            props.add(field);
        }
        return props;
    }

    private String firstToLowCase(String string) {
        return Character.toLowerCase(string.charAt(0)) + (string.length() > 1 ? string.substring(1) : "");
    }

    private boolean isGetter(Method method) {
        return method.getName().startsWith("get") || method.getName().startsWith("is");
    }

    private String getNameFromGetter(Method getter) {
        String[] getterPrefixes = new String[]{"get", "is"};
        String methodName = getter.getName();
        String fieldName = null;
        for (String prefix : getterPrefixes) {
            if (!methodName.startsWith(prefix)) continue;
            fieldName = methodName.substring(prefix.length());
        }
        if (fieldName == null) {
            return null;
        }
        fieldName = fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
        return fieldName;
    }
}

