/*
 * Decompiled with CFR 0.152.
 */
package com.github.rtyley.android.screenshot.paparazzo;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.RawImage;
import com.github.rtyley.android.screenshot.paparazzo.processors.ScreenshotProcessor;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OnDemandScreenshotService {
    private final IDevice device;
    private final List<ScreenshotProcessor> processors;
    private final ScreenshotRequestListener logListenerCommandShell;
    private static final Pattern KEY_VALUE_HOLDER_PATTERN = Pattern.compile("\\{(.*)\\}$");

    public OnDemandScreenshotService(IDevice device, ScreenshotProcessor ... processors) {
        this.device = device;
        this.processors = Arrays.asList(processors);
        this.logListenerCommandShell = new ScreenshotRequestListener();
    }

    public void start() {
        Thread thread = new Thread(new LogCatCommandExecutor());
        thread.setName(this.getClass().getSimpleName() + " logcat for " + this.device.getSerialNumber());
        thread.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.logListenerCommandShell.activate();
    }

    public void finish() {
        if (this.logListenerCommandShell != null) {
            this.logListenerCommandShell.cancel();
        }
        for (ScreenshotProcessor screenshotProcessor : this.processors) {
            screenshotProcessor.finish();
        }
    }

    private void takeScreenshotFor(String logLine) {
        RawImage rawImage;
        try {
            rawImage = this.device.getScreenshot();
        }
        catch (Exception e) {
            return;
        }
        if (rawImage == null) {
            return;
        }
        Map<String, String> keyValueMap = OnDemandScreenshotService.keyValueMapFor(logLine);
        BufferedImage image = OnDemandScreenshotService.bufferedImageFrom(rawImage);
        for (ScreenshotProcessor screenshotProcessor : this.processors) {
            screenshotProcessor.process(image, keyValueMap);
        }
    }

    static Map<String, String> keyValueMapFor(String logLine) {
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        Matcher matcher = KEY_VALUE_HOLDER_PATTERN.matcher(logLine);
        if (matcher.find()) {
            for (String keyValuePair : matcher.group(1).split(",")) {
                int separatorIndex = keyValuePair.indexOf("=");
                if (separatorIndex <= 0) continue;
                String key = keyValuePair.substring(0, separatorIndex);
                String value = keyValuePair.substring(separatorIndex + 1);
                keyValueMap.put(key, value);
            }
        }
        return keyValueMap;
    }

    private static BufferedImage bufferedImageFrom(RawImage rawImage) {
        BufferedImage image = new BufferedImage(rawImage.width, rawImage.height, 2);
        int index = 0;
        int bytesPerPixel = rawImage.bpp >> 3;
        for (int y = 0; y < rawImage.height; ++y) {
            for (int x = 0; x < rawImage.width; ++x) {
                image.setRGB(x, y, rawImage.getARGB(index) | 0xFF000000);
                index += bytesPerPixel;
            }
        }
        return image;
    }

    private class ScreenshotRequestListener
    extends MultiLineReceiver {
        private boolean activated = false;
        private boolean cancelled = false;

        public ScreenshotRequestListener() {
            this.setTrimLine(false);
        }

        public void activate() {
            this.activated = true;
        }

        public synchronized void cancel() {
            this.cancelled = true;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public synchronized void processNewLines(String[] lines) {
            if (!this.activated || this.cancelled) {
                return;
            }
            String mostRecentLogLine = lines[lines.length - 1];
            OnDemandScreenshotService.this.takeScreenshotFor(mostRecentLogLine);
        }
    }

    private class LogCatCommandExecutor
    implements Runnable {
        private static final String LOGCAT_COMMAND = "logcat -v raw -b main screenshot_request:D *:S";

        private LogCatCommandExecutor() {
        }

        @Override
        public void run() {
            try {
                OnDemandScreenshotService.this.device.executeShellCommand(LOGCAT_COMMAND, (IShellOutputReceiver)OnDemandScreenshotService.this.logListenerCommandShell, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

