/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.options;

import com.github.rvesse.airline.Context;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseOptionMissingValueException;
import com.github.rvesse.airline.parser.errors.ParseOptionUnexpectedException;
import com.github.rvesse.airline.parser.options.ListValueOptionParser;
import java.util.List;
import org.apache.commons.collections4.iterators.PeekingIterator;
import org.apache.commons.lang3.StringUtils;

public class MaybeListValueOptionParser<T>
extends ListValueOptionParser<T> {
    public MaybeListValueOptionParser() {
    }

    public MaybeListValueOptionParser(char separator) {
        super(separator);
    }

    @Override
    public ParseState<T> parseOptions(PeekingIterator<String> tokens, ParseState<T> state, List<OptionMetadata> allowedOptions) {
        String list;
        String name = (String)tokens.peek();
        boolean noSep = false;
        OptionMetadata option = this.findOption(state, allowedOptions, name);
        if (option == null) {
            if (this.hasShortNamePrefix(name) && name.length() > 2) {
                String shortName = name.substring(0, 2);
                option = this.findOption(state, allowedOptions, shortName);
                boolean bl = noSep = option != null;
            }
            if (!noSep) {
                return null;
            }
        }
        tokens.next();
        state = state.pushContext(Context.OPTION).withOption(option);
        String string = list = noSep ? name.substring(2) : null;
        if (option.getArity() == 0) {
            String rawBooleanValue = state.getParserConfiguration().allowsFlagNegation() && StringUtils.startsWith((CharSequence)name, (CharSequence)state.getParserConfiguration().getFlagNegationPrefix()) ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
            state = state.withOptionValue(option, rawBooleanValue).popContext();
        } else {
            boolean greedySearch;
            if (list == null) {
                if (!tokens.hasNext()) {
                    return state;
                }
                list = (String)tokens.next();
            }
            List<String> listValues = this.getValues(list);
            boolean bl = greedySearch = state.getCommand().getArguments() == null && state.getCommand().getDefaultOption() == null;
            while (tokens.hasNext() && (greedySearch || listValues.size() % option.getArity() != 0)) {
                String nextValue = (String)tokens.peek();
                OptionMetadata nextOption = this.findOption(state, allowedOptions, nextValue);
                if (nextOption == null && this.hasShortNamePrefix(nextValue) && nextValue.length() > 2) {
                    String shortName = nextValue.substring(0, 2);
                    nextOption = this.findOption(state, allowedOptions, shortName);
                    boolean bl2 = noSep = nextOption != null;
                }
                if (nextOption != null || StringUtils.equals((CharSequence)nextValue, (CharSequence)state.getParserConfiguration().getArgumentsSeparator())) break;
                nextValue = (String)tokens.next();
                listValues.addAll(this.getValues(nextValue));
            }
            if (listValues.size() < option.getArity()) {
                state.getParserConfiguration().getErrorHandler().handleError(new ParseOptionMissingValueException("Too few option values received for option %s in list value '%s' (%d values expected but only found %d)", option.getTitle(), option.getOptions().iterator().next(), list, option.getArity(), listValues.size()));
                return state;
            }
            if (listValues.size() > option.getArity() && listValues.size() % option.getArity() != 0) {
                state.getParserConfiguration().getErrorHandler().handleError(new ParseOptionUnexpectedException("Too many option values received for option %s in list value '%s' (%d values expected but found %d)", option.getOptions().iterator().next(), list, option.getArity(), listValues.size()));
                return state;
            }
            for (String value : listValues) {
                state = state.withOptionValue(option, value);
            }
            state = state.popContext();
        }
        return state;
    }
}

