/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.codecs.reads.bam;

import htsjdk.beta.plugin.HtsVersion;
import htsjdk.beta.plugin.reads.ReadsCodec;
import htsjdk.io.IOPath;
import htsjdk.utils.ValidationUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class BAMCodec
implements ReadsCodec {
    public static final HtsVersion BAM_DEFAULT_VERSION = new HtsVersion(1, 0, 0);
    private static final Set<String> extensionMap = new HashSet<String>(Arrays.asList(".bam"));

    @Override
    public String getFileFormat() {
        return "BAM";
    }

    @Override
    public boolean canDecodeURI(IOPath ioPath) {
        ValidationUtils.nonNull(ioPath, "ioPath");
        return extensionMap.stream().anyMatch(ext -> ioPath.hasExtension((String)ext));
    }
}

