/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.samtools.util.StringUtil;
import htsjdk.variant.variantcontext.Allele;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class SimpleAllele
implements Allele {
    private static final long serialVersionUID = 1L;
    private static final byte[] EMPTY_ALLELE_BASES = new byte[0];
    private boolean isRef = false;
    private boolean isNoCall = false;
    private boolean isSymbolic = false;
    private byte[] bases = null;

    protected SimpleAllele(byte[] bases, boolean isRef) {
        if (Allele.wouldBeNullAllele(bases)) {
            throw new IllegalArgumentException("Null alleles are not supported");
        }
        if (Allele.wouldBeNoCallAllele(bases)) {
            this.bases = EMPTY_ALLELE_BASES;
            this.isNoCall = true;
            if (isRef) {
                throw new IllegalArgumentException("Cannot tag a NoCall allele as the reference allele");
            }
            return;
        }
        if (Allele.wouldBeSymbolicAllele(bases)) {
            this.isSymbolic = true;
            if (isRef) {
                throw new IllegalArgumentException("Cannot tag a symbolic allele as the reference allele");
            }
        } else {
            StringUtil.toUpperCase(bases);
        }
        this.isRef = isRef;
        this.bases = bases;
        if (!Allele.acceptableAlleleBases(bases, isRef)) {
            throw new IllegalArgumentException("Unexpected base in allele bases '" + new String(bases) + "'");
        }
    }

    protected SimpleAllele(String bases, boolean isRef) {
        this(bases.getBytes(), isRef);
    }

    protected SimpleAllele(SimpleAllele allele, boolean ignoreRefState) {
        this.bases = allele.bases;
        this.isRef = ignoreRefState ? false : allele.isRef;
        this.isNoCall = allele.isNoCall;
        this.isSymbolic = allele.isSymbolic;
    }

    @Override
    public boolean isPrefixOf(Allele other) {
        if (other.length() < this.length()) {
            return false;
        }
        if (other instanceof SimpleAllele) {
            SimpleAllele baOther = (SimpleAllele)other;
            return this.isPrefixOfBytes(baOther.bases);
        }
        return this.isPrefixOfBytes(other.getBases());
    }

    private boolean isPrefixOfBytes(byte[] otherBases) {
        for (int i = 0; i < this.bases.length; ++i) {
            if (this.bases[i] == otherBases[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNoCall() {
        return this.isNoCall;
    }

    @Override
    public boolean isCalled() {
        return !this.isNoCall();
    }

    @Override
    public boolean isReference() {
        return this.isRef;
    }

    @Override
    public boolean isNonReference() {
        return !this.isReference();
    }

    @Override
    public boolean isSymbolic() {
        return this.isSymbolic;
    }

    @Override
    public boolean isBreakpoint() {
        return Allele.wouldBeBreakpoint(this.bases);
    }

    @Override
    public boolean isSingleBreakend() {
        return Allele.wouldBeSingleBreakend(this.bases);
    }

    @Override
    public String toString() {
        return (this.isNoCall() ? "." : this.getDisplayString()) + (this.isReference() ? "*" : "");
    }

    @Override
    public byte[] getBases() {
        return this.isSymbolic ? EMPTY_ALLELE_BASES : this.bases;
    }

    @Override
    public String getBaseString() {
        return this.isNoCall() ? "." : new String(this.getBases(), StandardCharsets.UTF_8);
    }

    @Override
    public String getDisplayString() {
        return new String(this.bases, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] getDisplayBases() {
        return this.bases;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof Allele && this.equals((Allele)other, false);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.bases) * 31 + Boolean.hashCode(this.isRef);
    }

    @Override
    public boolean equals(Allele other, boolean ignoreRefState) {
        if (this == other) {
            return true;
        }
        if (!ignoreRefState && this.isRef != other.isReference()) {
            return false;
        }
        return this.isNoCall == other.isNoCall() && Arrays.equals(this.bases, other.getDisplayBases());
    }

    @Override
    public boolean basesMatch(byte[] test) {
        return this.bases == test || Arrays.equals(this.bases, test);
    }

    @Override
    public boolean basesMatch(String test) {
        return this.basesMatch(test.toUpperCase().getBytes());
    }

    @Override
    public boolean basesMatch(Allele test) {
        return this.basesMatch(test.getBases());
    }

    @Override
    public int length() {
        return this.isSymbolic ? 0 : this.bases.length;
    }

    @Override
    public int compareTo(Allele other) {
        if (this.isReference() && other.isNonReference()) {
            return -1;
        }
        if (this.isNonReference() && other.isReference()) {
            return 1;
        }
        if (other instanceof SimpleAllele) {
            SimpleAllele baOther = (SimpleAllele)other;
            return this.compareBases(baOther.bases);
        }
        return this.compareBases(other.getBases());
    }

    private int compareBases(byte[] otherBases) {
        if (this.bases == otherBases) {
            return 0;
        }
        int stop = Math.min(otherBases.length, this.bases.length);
        for (int i = 0; i < stop; ++i) {
            int baseDiff = this.bases[i] - otherBases[i];
            if (baseDiff == 0) continue;
            return baseDiff < 0 ? -1 : 1;
        }
        return Integer.compare(this.bases.length, otherBases.length);
    }

    @Override
    public boolean isNonRefAllele() {
        return this.equals(NON_REF_ALLELE) || this.equals(UNSPECIFIED_ALTERNATE_ALLELE);
    }
}

