/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.sonar.plugins.yaml;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.github.sbaudoin.sonar.plugins.yaml.languages.YamlLanguage;
import com.github.sbaudoin.sonar.plugins.yaml.languages.YamlQualityProfile;
import com.github.sbaudoin.sonar.plugins.yaml.rules.YamlRulesDefinition;
import com.github.sbaudoin.sonar.plugins.yaml.rules.YamlSensor;
import com.github.sbaudoin.sonar.plugins.yaml.settings.YamlSettings;
import org.reflections.Reflections;
import org.slf4j.LoggerFactory;
import org.sonar.api.Plugin;
import org.sonar.api.utils.Version;

public class YamlPlugin
implements Plugin {
    static final Version SONARQUBE_WITH_YAML_SUPPORT_VERSION = Version.create((int)9, (int)2);

    public YamlPlugin() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        context.getLogger(Reflections.class).setLevel(Level.ERROR);
    }

    public void define(Plugin.Context context) {
        boolean hasBuiltinYamlSupport = YamlPlugin.hasBuiltinYamlLanguageSupport(context);
        if (!hasBuiltinYamlSupport) {
            context.addExtension(YamlLanguage.class);
        }
        context.addExtension((Object)new YamlQualityProfile(hasBuiltinYamlSupport));
        context.addExtensions(YamlSettings.getProperties(hasBuiltinYamlSupport));
        context.addExtensions(YamlRulesDefinition.class, YamlSensor.class, new Object[0]);
    }

    public static boolean hasBuiltinYamlLanguageSupport(Plugin.Context context) {
        return context.getSonarQubeVersion().isGreaterThanOrEqual(SONARQUBE_WITH_YAML_SUPPORT_VERSION);
    }
}

