/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.sonar.plugins.yaml.checks;

import com.github.sbaudoin.sonar.plugins.yaml.checks.YamlCheck;
import com.github.sbaudoin.sonar.plugins.yaml.checks.YamlIssue;
import com.github.sbaudoin.yamllint.LintScanner;
import java.io.IOException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.check.RuleProperty;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.tokens.KeyToken;
import org.yaml.snakeyaml.tokens.ScalarToken;
import org.yaml.snakeyaml.tokens.Token;

public abstract class ForbiddenCheck
extends YamlCheck {
    private static final Logger LOGGER = Loggers.get(ForbiddenCheck.class);
    @RuleProperty(key="key-name", description="Regexp that matches the forbidden name")
    String keyName;

    @Override
    public void validate() {
        if (this.yamlSourceCode == null) {
            throw new IllegalStateException("Source code not set, cannot validate anything");
        }
        try {
            LintScanner parser = new LintScanner(new StreamReader(this.yamlSourceCode.getContent()));
            if (!this.yamlSourceCode.hasCorrectSyntax()) {
                LOGGER.warn("Syntax error found, cannot continue checking keys: " + this.yamlSourceCode.getSyntaxError().getMessage());
                return;
            }
            while (parser.hasMoreTokens()) {
                Token t2;
                Token t1 = parser.getToken();
                if (!(t1 instanceof KeyToken) || !parser.hasMoreTokens() || !((t2 = parser.peekToken()) instanceof ScalarToken) || !((ScalarToken)t2).getValue().matches(this.keyName)) continue;
                this.checkNextToken(parser);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Cannot read source code", (Throwable)e);
        }
    }

    protected abstract void checkNextToken(LintScanner var1);

    protected void addViolation(String message, Token t) {
        this.getYamlSourceCode().addViolation(new YamlIssue(this.getRuleKey(), message, t.getStartMark().getLine() + 1, t.getStartMark().getColumn() + 1));
    }
}

