/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.sonar.plugins.yaml.checks;

import com.github.sbaudoin.sonar.plugins.yaml.checks.YamlCheck;
import com.github.sbaudoin.sonar.plugins.yaml.checks.YamlIssue;
import com.github.sbaudoin.yamllint.LintScanner;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.tokens.KeyToken;
import org.yaml.snakeyaml.tokens.ScalarToken;
import org.yaml.snakeyaml.tokens.Token;
import org.yaml.snakeyaml.tokens.ValueToken;

@Rule(key="RequiredKeyCheck")
public class RequiredKeyCheck
extends YamlCheck {
    private static final Logger LOGGER = Loggers.get(RequiredKeyCheck.class);
    private static final int FIRST_COLUMN = 0;
    private int issueLine = 0;
    @RuleProperty(key="parent-key-name", description="Regexp that matches the prerequisite parent-key-name")
    String keyName;
    @RuleProperty(key="parent-key-value", description="Regexp that matches the value for the prerequisite parent-key-name")
    String keyValue;
    @RuleProperty(key="parent-key-name-root", description="Filter only root keys for the parent-key-name (allowed values: 'yes', 'not' or 'anywhere')", defaultValue="anywhere")
    String isKeyNameAtRoot;
    @RuleProperty(key="required-key-name", description="Regexp that matches the required key name for the required-key-name")
    String requiredKeyName;

    @Override
    public void validate() {
        if (this.yamlSourceCode == null) {
            throw new IllegalStateException("Source code not set, cannot validate anything");
        }
        try {
            LintScanner parser = new LintScanner(new StreamReader(this.yamlSourceCode.getContent()));
            if (!this.yamlSourceCode.hasCorrectSyntax()) {
                LOGGER.warn("Syntax error found, cannot continue checking keys: " + this.yamlSourceCode.getSyntaxError().getMessage());
                return;
            }
            boolean isKeyPresent = false;
            boolean isRequiredKeyPresent = false;
            while (parser.hasMoreTokens()) {
                Token t2;
                Token t1 = parser.getToken();
                if (!(t1 instanceof KeyToken) || !parser.hasMoreTokens() || !((t2 = parser.peekToken()) instanceof ScalarToken)) continue;
                if (((ScalarToken)t2).getValue().matches(this.keyName)) {
                    boolean isNewMatch = this.checkValue(parser);
                    int column = t1.getStartMark().getColumn();
                    if (this.isKeyNameAtRoot.equalsIgnoreCase("yes") && column != 0 || this.isKeyNameAtRoot.equalsIgnoreCase("not") && column == 0) continue;
                    if (isKeyPresent && isNewMatch && !isRequiredKeyPresent) {
                        this.checkNextToken();
                    }
                    isKeyPresent = isNewMatch;
                    isRequiredKeyPresent = !isNewMatch && isRequiredKeyPresent;
                    this.issueLine = isNewMatch ? t2.getStartMark().getLine() : this.issueLine;
                    continue;
                }
                if (!((ScalarToken)t2).getValue().matches(this.requiredKeyName) || !isKeyPresent) continue;
                isRequiredKeyPresent = true;
            }
            if (!isRequiredKeyPresent && isKeyPresent) {
                this.checkNextToken();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Cannot read source code", (Throwable)e);
        }
    }

    private boolean checkValue(LintScanner parser) {
        boolean isKeyPresent = false;
        parser.getToken();
        if (parser.peekToken() instanceof ValueToken) {
            Matcher m;
            parser.getToken();
            Token t3 = parser.peekToken();
            if (t3 instanceof ScalarToken && (m = Pattern.compile("(?m)" + this.keyValue).matcher(((ScalarToken)t3).getValue())).find()) {
                isKeyPresent = true;
            }
        }
        return isKeyPresent;
    }

    private void checkNextToken() {
        this.addViolation("Required " + this.requiredKeyName + " key not found");
    }

    private void addViolation(String message) {
        this.getYamlSourceCode().addViolation(new YamlIssue(this.getRuleKey(), message, this.issueLine + 1, 1));
    }
}

