/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.sonar.plugins.yaml.checks;

import com.github.sbaudoin.sonar.plugins.yaml.checks.YamlCheck;
import com.github.sbaudoin.sonar.plugins.yaml.checks.YamlLintIssue;
import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.Linter;
import com.github.sbaudoin.yamllint.YamlLintConfig;
import com.github.sbaudoin.yamllint.YamlLintConfigException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.check.RuleProperty;

public abstract class YamlLintCheck
extends YamlCheck {
    private static final Logger LOGGER = Loggers.get(YamlLintCheck.class);

    @Override
    public void validate() {
        if (this.yamlSourceCode == null) {
            throw new IllegalStateException("Source code not set, cannot validate anything");
        }
        try {
            List allProblems = Linter.getCosmeticProblems((CharSequence)this.getYamlSourceCode().getContent(), (YamlLintConfig)this.getYamlLintconfig(), null);
            List problems = allProblems.stream().filter(p -> p.getRuleId().equals(this.getLintRuleId())).collect(Collectors.toList());
            LOGGER.debug("Problems found: " + problems);
            for (LintProblem problem : problems) {
                LOGGER.debug("Creating violation for " + problem);
                this.createViolation(problem);
            }
        }
        catch (YamlLintConfigException e) {
            LOGGER.warn("Cannot get YamlLintConfig for rule '" + this.getLintRuleId() + "'", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.warn("Cannot read source code", (Throwable)e);
        }
    }

    protected final void createViolation(LintProblem violation) {
        this.getYamlSourceCode().addViolation(new YamlLintIssue(violation, this.getRuleKey()));
    }

    protected final void createViolation(LintProblem violation, boolean syntaxError) {
        this.getYamlSourceCode().addViolation(new YamlLintIssue(violation, this.getRuleKey(), syntaxError));
    }

    protected boolean isFileIncluded(@Nullable String filePattern) {
        if (filePattern != null) {
            return WildcardPattern.create((String)filePattern).match(this.getYamlSourceCode().getYamlFile().uri().getPath());
        }
        return true;
    }

    protected String getLintRuleId() {
        return this.getId();
    }

    protected YamlLintConfig getYamlLintconfig() throws YamlLintConfigException {
        if (this.config != null) {
            return this.config;
        }
        StringBuilder propsSB = new StringBuilder();
        for (Field f : this.getClass().getDeclaredFields()) {
            RuleProperty rp = f.getAnnotation(RuleProperty.class);
            LOGGER.debug("Got RuleProperty " + rp);
            if (rp == null) continue;
            try {
                propsSB.append("    ").append(rp.key()).append(": ").append(f.get(this)).append("\n");
            }
            catch (IllegalAccessException e) {
                LOGGER.warn("Cannot get field value for '" + f.getName() + "'", (Throwable)e);
                return null;
            }
        }
        return this.getYamlLintconfig(propsSB);
    }

    protected YamlLintConfig getYamlLintconfig(CharSequence conf) throws YamlLintConfigException {
        StringBuilder confSB = new StringBuilder("---\n").append("rules:\n").append("  ").append(this.getLintRuleId()).append(":");
        if (conf.length() == 0) {
            confSB.append(" enable");
        } else {
            confSB.append("\n").append(conf);
        }
        LOGGER.debug("YAMLLint config for rule " + this.getRuleKey() + "/" + this.getLintRuleId() + ": '" + confSB + "'");
        return new YamlLintConfig((CharSequence)confSB.toString());
    }
}

