/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.sonar.plugins.yaml.highlighting;

import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;

public class HighlightingData {
    private final TypeOfText typeOfText;
    private int startLine;
    private int startColumnOffset;
    private int endLine;
    private int endColumnOffset;

    public HighlightingData(int startLine, int startColumnIndex, int endLine, int endColumnIndex, TypeOfText typeOfText) {
        this.startLine = startLine;
        this.startColumnOffset = startColumnIndex - 1;
        this.endLine = endLine;
        this.endColumnOffset = endColumnIndex - 1;
        this.typeOfText = typeOfText;
    }

    public void highlight(NewHighlighting highlighting) {
        highlighting.highlight(this.startLine, this.startColumnOffset, this.endLine, this.endColumnOffset, this.typeOfText);
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartColumnIndex() {
        return this.startColumnOffset + 1;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumnIndex() {
        return this.endColumnOffset + 1;
    }

    public TypeOfText getTypeOfText() {
        return this.typeOfText;
    }
}

