/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.sonar.plugins.yaml.highlighting;

import com.github.sbaudoin.sonar.plugins.yaml.checks.YamlSourceCode;
import com.github.sbaudoin.sonar.plugins.yaml.highlighting.HighlightingData;
import com.github.sbaudoin.sonar.plugins.yaml.highlighting.YamlLocation;
import com.github.sbaudoin.yamllint.Parser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.yaml.snakeyaml.tokens.Token;

public class YamlHighlighting {
    private static final Logger LOGGER = Loggers.get(YamlHighlighting.class);
    public static final String BOM_CHAR = "\ufeff";
    private List<HighlightingData> highlighting = new ArrayList<HighlightingData>();
    private TypeOfText currentCode = TypeOfText.KEYWORD;
    private String content;

    public YamlHighlighting(YamlSourceCode sourceCode) throws IOException {
        if (sourceCode == null) {
            throw new IllegalArgumentException("Input YAML source code cannot be null");
        }
        this.process(sourceCode.getContent());
    }

    private void process(String yamlStrContent) {
        if ("".equals(yamlStrContent)) {
            return;
        }
        if (yamlStrContent.startsWith(BOM_CHAR)) {
            LOGGER.debug("Document starts with BOM sequence");
            yamlStrContent = yamlStrContent.substring(1);
        }
        this.content = yamlStrContent;
        this.highlightYAML();
    }

    public List<HighlightingData> getHighlightingData() {
        return this.highlighting;
    }

    private void highlightYAML() {
        for (Parser.Lined item : Parser.getTokensOrComments((String)this.content)) {
            if (item instanceof Parser.Comment) {
                this.highlightComment((Parser.Comment)item);
                continue;
            }
            this.highlightToken((Parser.Token)item);
        }
    }

    private void highlightComment(Parser.Comment comment) {
        YamlLocation startLocation = new YamlLocation(this.content, comment.getLineNo(), comment.getColumnNo(), 0);
        YamlLocation endLocation = new YamlLocation(this.content, comment.getTokenAfter().getStartMark());
        LOGGER.trace("Highlighting comment: " + comment);
        this.addHighlighting(startLocation, endLocation, TypeOfText.COMMENT);
    }

    private void highlightToken(Parser.Token token) {
        Token currentToken = token.getCurr();
        YamlLocation startLocation = new YamlLocation(this.content, currentToken.getStartMark());
        YamlLocation endLocation = new YamlLocation(this.content, currentToken.getEndMark());
        switch (currentToken.getTokenId()) {
            case DocumentStart: 
            case DocumentEnd: {
                LOGGER.trace("Highlighting document start: ---");
                this.addHighlighting(startLocation, endLocation, TypeOfText.CONSTANT);
                break;
            }
            case Key: {
                LOGGER.trace("Key to come");
                this.currentCode = TypeOfText.KEYWORD;
                break;
            }
            case Value: {
                LOGGER.trace("Value to come");
                this.currentCode = TypeOfText.STRING;
                break;
            }
            case Scalar: {
                LOGGER.trace("Highlighting scalar of type " + this.currentCode + ": " + this.content.substring(currentToken.getStartMark().getIndex(), currentToken.getEndMark().getIndex()));
                this.addHighlighting(startLocation, endLocation, this.currentCode);
                break;
            }
            case Directive: {
                LOGGER.trace("Highlighting directive: " + this.content.substring(currentToken.getStartMark().getIndex(), currentToken.getEndMark().getIndex()));
                this.addHighlighting(startLocation, endLocation, TypeOfText.COMMENT);
                break;
            }
            case Anchor: 
            case Alias: {
                LOGGER.trace("Highlighting anchor or alias: " + this.content.substring(currentToken.getStartMark().getIndex(), currentToken.getEndMark().getIndex()));
                this.addHighlighting(startLocation, endLocation, TypeOfText.ANNOTATION);
                break;
            }
            case Tag: {
                LOGGER.trace("Highlighting tag: " + this.content.substring(currentToken.getStartMark().getIndex(), currentToken.getEndMark().getIndex()));
                this.addHighlighting(startLocation, endLocation, TypeOfText.PREPROCESS_DIRECTIVE);
                break;
            }
        }
    }

    private void addHighlighting(YamlLocation start, YamlLocation end, TypeOfText typeOfText) {
        if (start.isSameAs(end)) {
            throw new IllegalArgumentException("Cannot highlight an empty range");
        }
        this.highlighting.add(new HighlightingData(start.line(), start.column(), end.line(), end.column(), typeOfText));
    }
}

