/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.sonar.plugins.yaml.languages;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Configuration;
import org.sonar.api.resources.AbstractLanguage;

public class YamlLanguage
extends AbstractLanguage {
    public static final String NAME = "YAML";
    public static final String KEY = "yaml";
    private final Configuration config;

    public YamlLanguage(Configuration config) {
        super(KEY, NAME);
        this.config = config;
    }

    public String[] getFileSuffixes() {
        String[] suffixes = this.filterEmptyStrings(this.config.getStringArray("sonar.yaml.file.suffixes"));
        if (suffixes.length == 0) {
            suffixes = StringUtils.split((String)".yaml,.yml", (String)",");
        }
        return suffixes;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private String[] filterEmptyStrings(String[] stringArray) {
        ArrayList<String> nonEmptyStrings = new ArrayList<String>();
        for (String string : stringArray) {
            if (!StringUtils.isNotBlank((String)string.trim())) continue;
            nonEmptyStrings.add(string.trim());
        }
        return nonEmptyStrings.toArray(new String[0]);
    }
}

