/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.sonar.plugins.yaml.linecounter;

import com.github.sbaudoin.sonar.plugins.yaml.checks.YamlSourceCode;
import com.github.sbaudoin.sonar.plugins.yaml.linecounter.LineCountData;
import com.github.sbaudoin.sonar.plugins.yaml.linecounter.LineCountParser;
import java.io.IOException;
import java.io.Serializable;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.measures.Metric;
import org.sonar.api.utils.Version;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class LineCounter {
    private static final Logger LOGGER = Loggers.get(LineCounter.class);

    private LineCounter() {
    }

    public static void analyse(SensorContext context, FileLinesContextFactory fileLinesContextFactory, YamlSourceCode sourceCode) {
        InputFile inputFile = sourceCode.getYamlFile();
        LOGGER.debug("Count lines in {}", (Object)inputFile.filename());
        try {
            LineCounter.saveMeasures(inputFile, new LineCountParser(sourceCode.getContent()).getLineCountData(), fileLinesContextFactory.createFor(inputFile), context);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to count lines for file " + inputFile.filename() + ", ignoring measures", (Throwable)e);
        }
    }

    private static void saveMeasures(InputFile yamlFile, LineCountData data, FileLinesContext fileLinesContext, SensorContext context) {
        for (int line = 1; line <= data.linesNumber(); ++line) {
            fileLinesContext.setIntValue("ncloc_data", line, data.linesOfCodeLines().contains(line) ? 1 : 0);
            if (!Version.create((int)7, (int)3).isGreaterThanOrEqual(context.getSonarQubeVersion())) continue;
            fileLinesContext.setIntValue("comment_lines_data", line, data.effectiveCommentLines().contains(line) ? 1 : 0);
        }
        fileLinesContext.save();
        LineCounter.saveMeasure(context, yamlFile, CoreMetrics.COMMENT_LINES, data.effectiveCommentLines().size());
        LineCounter.saveMeasure(context, yamlFile, CoreMetrics.NCLOC, data.linesOfCodeLines().size());
    }

    private static <T extends Serializable> void saveMeasure(SensorContext context, InputFile inputFile, Metric<T> metric, T value) {
        context.newMeasure().withValue(value).forMetric(metric).on((InputComponent)inputFile).save();
    }
}

