/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint;

import com.github.sbaudoin.yamllint.YamlLintConfigException;
import com.github.sbaudoin.yamllint.rules.Rule;
import com.github.sbaudoin.yamllint.rules.RuleFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.input.CharSequenceReader;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.reader.UnicodeReader;

public class YamlLintConfig {
    public static final String EXTENDS_KEY = "extends";
    public static final String YAML_FILES_KEY = "yaml-files";
    public static final String IGNORE_KEY = "ignore";
    public static final String RULES_KEY = "rules";
    protected Map<String, Object> ruleConf;
    protected List<String> ignore = null;
    protected List<String> yamlFiles = Arrays.asList(".*\\.yaml$", ".*\\.yml$");

    public YamlLintConfig(CharSequence content) throws YamlLintConfigException {
        if (content == null) {
            throw new IllegalArgumentException("content cannot be null");
        }
        this.parse(content);
        this.validate();
    }

    public YamlLintConfig(URL file) throws IOException, YamlLintConfigException {
        if (file != null) {
            try (Scanner scanner = new Scanner(file.openStream()).useDelimiter("\\A");){
                this.parse(scanner.next());
            }
        } else {
            throw new IllegalArgumentException("file cannot be null");
        }
        this.validate();
    }

    public YamlLintConfig(InputStream in) throws YamlLintConfigException {
        if (in == null) {
            throw new IllegalArgumentException("in cannot be null");
        }
        this.parse(in);
    }

    public boolean isYamlFile(String filepath) {
        return this.yamlFiles.stream().anyMatch(filepath::matches);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isFileIgnored(String filepath) {
        if (this.ignore == null) return false;
        if (!this.ignore.stream().anyMatch(filepath::matches)) return false;
        return true;
    }

    public List<Rule> getEnabledRules(File file) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Map.Entry<String, Object> entry : this.ruleConf.entrySet()) {
            Rule rule = RuleFactory.instance.getRule(entry.getKey());
            if (rule == null || entry.getValue() == null || file != null && rule.ignores(file)) continue;
            rules.add(rule);
        }
        return rules;
    }

    public Object getRuleConf(String id) {
        return this.ruleConf.get(id);
    }

    public void extend(YamlLintConfig baseConfig) {
        assert (this.ruleConf != null);
        HashMap<String, Object> newConf = new HashMap<String, Object>(baseConfig.ruleConf);
        for (Map.Entry<String, Object> entry : this.ruleConf.entrySet()) {
            String ruleId = entry.getKey();
            Object conf = entry.getValue();
            if (conf instanceof Map && newConf.get(ruleId) != null) {
                YamlLintConfig.deepMerge((Map)newConf.get(ruleId), (Map)conf);
                continue;
            }
            newConf.put(ruleId, conf);
        }
        this.ruleConf = newConf;
        if (baseConfig.yamlFiles != null) {
            this.yamlFiles = baseConfig.yamlFiles;
        }
        if (baseConfig.ignore != null) {
            this.ignore = baseConfig.ignore;
        }
    }

    protected void parse(CharSequence rawContent) throws YamlLintConfigException {
        try (CharSequenceReader r = new CharSequenceReader(rawContent);){
            this.parse((Reader)r);
        }
    }

    protected void parse(InputStream in) throws YamlLintConfigException {
        this.parse((Reader)new UnicodeReader(in));
    }

    protected void parse(Reader r) throws YamlLintConfigException {
        Map conf;
        try {
            conf = (Map)new Yaml().load(r);
        }
        catch (ClassCastException | YAMLException e) {
            throw YamlLintConfig.getInvalidConfigException("YAML", e.getMessage(), e);
        }
        if (conf == null) {
            throw YamlLintConfig.getInvalidConfigException("not a dictionary");
        }
        this.ruleConf = conf.getOrDefault(RULES_KEY, new HashMap());
        if (conf.containsKey(EXTENDS_KEY)) {
            try {
                YamlLintConfig base = new YamlLintConfig(this.getExtendedConfigFile((String)conf.get(EXTENDS_KEY)));
                this.extend(base);
            }
            catch (IllegalArgumentException e) {
                throw YamlLintConfig.getInvalidConfigException(EXTENDS_KEY, e.getMessage(), e);
            }
            catch (Exception e) {
                throw YamlLintConfig.getInvalidConfigException(EXTENDS_KEY, "unknown error: " + e.getMessage(), e);
            }
        }
        if (conf.containsKey(YAML_FILES_KEY)) {
            if (!(conf.get(YAML_FILES_KEY) instanceof List)) {
                throw YamlLintConfig.getInvalidConfigException(String.format("'%s' must be a list (of regexp patterns)", YAML_FILES_KEY));
            }
            this.yamlFiles = (List)conf.get(YAML_FILES_KEY);
        }
        if (conf.containsKey(IGNORE_KEY)) {
            if (!(conf.get(IGNORE_KEY) instanceof String)) {
                throw YamlLintConfig.getInvalidConfigException(String.format("'%s' should contain file patterns", IGNORE_KEY));
            }
            this.ignore = Arrays.asList(((String)conf.get(IGNORE_KEY)).split("\\r?\\n"));
        }
    }

    protected void validate() throws YamlLintConfigException {
        for (Map.Entry<String, Object> entry : this.ruleConf.entrySet()) {
            String id = entry.getKey();
            Rule rule = RuleFactory.instance.getRule(id);
            if (rule == null) {
                throw YamlLintConfig.getInvalidConfigException(String.format("no such rule: \"%s\"", id));
            }
            Map<String, Object> newConf = YamlLintConfig.validateRuleConf(rule, entry.getValue());
            this.ruleConf.put(id, newConf);
        }
    }

    protected static Map<String, Object> validateRuleConf(Rule rule, Object conf) throws YamlLintConfigException {
        HashMap myConf = conf;
        if (myConf == null || "disable".equals(myConf)) {
            return null;
        }
        if ("enable".equals(myConf)) {
            myConf = new HashMap();
        }
        if (!(myConf instanceof Map)) {
            throw YamlLintConfig.getInvalidConfigException(String.format("rule \"%s\": should be either \"enable\", \"disable\" or a dictionary", rule.getId()));
        }
        Map mapConf = myConf;
        YamlLintConfig.setIgnoreConf(rule, mapConf);
        YamlLintConfig.setRuleLevel(rule, mapConf);
        Map<String, Object> options = rule.getOptions();
        for (Map.Entry entry : mapConf.entrySet()) {
            String optkey = (String)entry.getKey();
            Object optvalue = entry.getValue();
            if (IGNORE_KEY.equals(optkey) || "level".equals(optkey)) continue;
            if (!options.containsKey(optkey)) {
                throw YamlLintConfig.getInvalidConfigException(String.format("unknown option \"%s\" for rule \"%s\"", optkey, rule.getId()));
            }
            if (options.get(optkey) instanceof List && !rule.isListOption(optkey)) {
                if (!((List)options.get(optkey)).contains(optvalue) && ((List)options.get(optkey)).stream().noneMatch(object -> optvalue.getClass().equals(object))) {
                    throw YamlLintConfig.getInvalidConfigException(String.format("option \"%s\" of \"%s\" should be in %s", optkey, rule.getId(), YamlLintConfig.getListRepresentation((List)options.get(optkey))));
                }
            } else if (rule.isListOption(optkey)) {
                if (!(optvalue instanceof List)) {
                    throw YamlLintConfig.getInvalidConfigException(String.format("option \"%s\" of \"%s\" should be a list", optkey, rule.getId()));
                }
            } else if (!optvalue.getClass().equals(options.get(optkey).getClass())) {
                throw YamlLintConfig.getInvalidConfigException(String.format("option \"%s\" of \"%s\" should be of type %s", optkey, rule.getId(), options.get(optkey).getClass().getSimpleName().toLowerCase()));
            }
            rule.addParameter(optkey, optvalue);
        }
        for (String optkey : options.keySet()) {
            if (mapConf.containsKey(optkey)) continue;
            mapConf.put(optkey, rule.getDefaultOptionValue(optkey));
        }
        String validationMessage = rule.validate(mapConf);
        if (validationMessage != null && !"".equals(validationMessage)) {
            throw YamlLintConfig.getInvalidConfigException(String.format("%s: %s", rule.getId(), validationMessage));
        }
        return mapConf;
    }

    private static void setIgnoreConf(Rule rule, Map<String, Object> conf) throws YamlLintConfigException {
        if (conf.containsKey(IGNORE_KEY)) {
            if (conf.get(IGNORE_KEY) instanceof List) {
                rule.setIgnore((List)conf.get(IGNORE_KEY));
            } else {
                if (!(conf.get(IGNORE_KEY) instanceof String)) {
                    throw YamlLintConfig.getInvalidConfigException("ignore should contain regexp patterns");
                }
                rule.setIgnore(Arrays.asList(((String)conf.get(IGNORE_KEY)).split("\\r?\\n")));
            }
        }
    }

    private static void setRuleLevel(Rule rule, Map<String, Object> conf) throws YamlLintConfigException {
        if (!conf.containsKey("level")) {
            rule.setLevel("error");
            conf.put("level", "error");
        } else if (conf.containsKey("level") && ("error".equals(conf.get("level")) || "warning".equals(conf.get("level")) || "info".equals(conf.get("level")))) {
            rule.setLevel((String)conf.get("level"));
        } else {
            throw YamlLintConfig.getInvalidConfigException(String.format("level should be \"%s\", \"%s\" or \"%s\"", "error", "warning", "info"));
        }
    }

    protected URL getExtendedConfigFile(String name) {
        if (name == null || "".equals(name.trim())) {
            throw new IllegalArgumentException("need to extend something");
        }
        if (!name.contains(File.separator)) {
            URL url = this.getClass().getClassLoader().getResource("conf/" + name + ".yaml");
            if (url == null) {
                throw new IllegalArgumentException("Bundled configuration file \"" + name + "\" not found");
            }
            return url;
        }
        try {
            return new File(name.replace('/', File.separatorChar)).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Cannot create URL for the configuration file \"" + name + "\"", e);
        }
    }

    protected static String getListRepresentation(@Nonnull List<Object> list) {
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        for (Object o : list) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            if (o instanceof String) {
                sb.append("'").append(o).append("'");
                continue;
            }
            if (o instanceof Class) {
                sb.append(((Class)o).getSimpleName().toLowerCase());
                continue;
            }
            sb.append(o);
        }
        return sb.append("]").toString();
    }

    protected static Map<Object, Object> deepMerge(Map<Object, Object> original, Map<Object, Object> newMap) {
        for (Map.Entry<Object, Object> entry : newMap.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key instanceof Map && original.get(key) instanceof Map) {
                original.put(key, YamlLintConfig.deepMerge((Map)original.get(key), (Map)value));
                continue;
            }
            if (key instanceof List && original.get(key) instanceof List) {
                List originalChild = (List)original.get(key);
                for (Object each : (List)value) {
                    if (originalChild.contains(each)) continue;
                    originalChild.add(each);
                }
                continue;
            }
            original.put(key, value);
        }
        return original;
    }

    private static YamlLintConfigException getInvalidConfigException(String message) {
        return YamlLintConfig.getInvalidConfigException(null, message, null);
    }

    private static YamlLintConfigException getInvalidConfigException(@Nullable String specifier, String message, @Nullable Throwable e) {
        String m = String.format("invalid%s config: %s", specifier == null ? "" : " " + specifier, message);
        if (e == null) {
            return new YamlLintConfigException(m);
        }
        return new YamlLintConfigException(m, e);
    }
}

