/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class SingleBreakOrContinueCheck
extends AbstractCheck {
    public static final String MSG_KEY = "single.break.or.continue.in.loops";

    public int[] getDefaultTokens() {
        return new int[]{91, 84, 85};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        if (this.getNumberOfContinueAndBreaks(ast.getFirstChild()) > 1) {
            this.log(ast, MSG_KEY, new Object[0]);
        }
    }

    private int getNumberOfContinueAndBreaks(DetailAST node) {
        int numberOfBreakOrContinue = 0;
        if (node != null) {
            if (87 == node.getType() || 86 == node.getType()) {
                ++numberOfBreakOrContinue;
            } else if (SingleBreakOrContinueCheck.shouldIgnore(node)) {
                numberOfBreakOrContinue += this.getNumberOfContinueAndBreaks(node.getNextSibling());
            } else {
                numberOfBreakOrContinue += this.getNumberOfContinueAndBreaks(node.getFirstChild());
                numberOfBreakOrContinue += this.getNumberOfContinueAndBreaks(node.getNextSibling());
            }
        }
        return numberOfBreakOrContinue;
    }

    private static boolean shouldIgnore(DetailAST node) {
        return 89 == node.getType() || 91 == node.getType() || 84 == node.getType() || 85 == node.getType();
    }
}

