/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.design;

import com.github.sevntu.checkstyle.SevntuUtil;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class CheckstyleTestMakeupCheck
extends AbstractCheck {
    public static final String MSG_KEY_CONFIG_NOT_ASSIGNED = "tester.config.not.assigned";
    public static final String MSG_KEY_CONFIG_NOT_ASSIGNED_WITH = "tester.config.not.assigned.with";
    public static final String MSG_KEY_CONFIG_NOT_ASSIGNED_PROPERLY = "tester.config.not.assigned.properly";
    public static final String MSG_KEY_UNKNOWN_PROPERTY = "tester.unknown.property";
    public static final String MSG_KEY_CONFIG_NOT_FOUND = "tester.config.not.found";
    private static final String METHOD_GET_PATH = "getPath";
    private DetailAST methodAst;
    private final Set<String> fileVariableNames = new HashSet<String>();
    private final Set<String> checkConfigNames = new HashSet<String>();
    private boolean foundVerify;
    private final Map<DetailAST, String> violations = new HashMap<DetailAST, String>();
    private Pattern createMethodRegexp = Pattern.compile("create(Root|Module)Config|getModuleConfig");
    private Pattern verifyMethodRegexp = Pattern.compile("verify(Warns|Suppressed)?");

    public void setCreateMethodRegexp(Pattern createMethodRegexp) {
        this.createMethodRegexp = createMethodRegexp;
    }

    public void setVerifyMethodRegexp(Pattern verifyMethodRegexp) {
        this.verifyMethodRegexp = verifyMethodRegexp;
    }

    public int[] getDefaultTokens() {
        return new int[]{9, 10, 27};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void beginTree(DetailAST rootAST) {
        this.resetInternalFields();
    }

    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 9: {
                this.checkMethod(ast);
                break;
            }
            case 10: {
                this.checkVariable(ast);
                break;
            }
            case 27: {
                this.checkMethodCall(ast);
                break;
            }
            default: {
                SevntuUtil.reportInvalidToken(ast.getType());
            }
        }
    }

    private void checkMethod(DetailAST ast) {
        if (this.methodAst == null && AnnotationUtil.containsAnnotation((DetailAST)ast, (String)"Test") || AnnotationUtil.containsAnnotation((DetailAST)ast, (String)"org.junit.jupiter.api.Test") || AnnotationUtil.containsAnnotation((DetailAST)ast, (String)"org.junit.Test")) {
            this.methodAst = ast;
        }
    }

    private void checkVariable(DetailAST ast) {
        DetailAST type;
        if (this.methodAst != null && ScopeUtil.isLocalVariableDef((DetailAST)ast) && (type = ast.findFirstToken(13).findFirstToken(58)) != null) {
            String typeText = type.getText();
            if ("DefaultConfiguration".equals(typeText) || "Configuration".equals(typeText)) {
                this.checkConfigurationVariable(ast);
            } else if ("File".equals(typeText) && ast.findFirstToken(5).findFirstToken(39) != null) {
                this.fileVariableNames.add(ast.findFirstToken(58).getText());
            }
        }
    }

    private void checkConfigurationVariable(DetailAST ast) {
        this.checkConfigNames.add(ast.findFirstToken(58).getText());
        DetailAST assignment = ast.findFirstToken(80);
        if (assignment == null) {
            this.violations.put(ast, MSG_KEY_CONFIG_NOT_ASSIGNED);
        } else if (assignment.getFirstChild().getFirstChild().getType() == 27) {
            DetailAST assignmentMethod = assignment.getFirstChild().getFirstChild().findFirstToken(58);
            if (assignmentMethod != null && !this.createMethodRegexp.matcher(assignmentMethod.getText()).matches()) {
                this.violations.put(assignment, MSG_KEY_CONFIG_NOT_ASSIGNED_WITH);
            }
        } else if (assignment.getFirstChild().getFirstChild().getType() != 135) {
            this.violations.put(ast, MSG_KEY_CONFIG_NOT_ASSIGNED_PROPERLY);
        }
    }

    private void checkMethodCall(DetailAST ast) {
        if (this.methodAst != null) {
            DetailAST firstChild = ast.getFirstChild();
            String methodCallName = this.getMethodCallName(firstChild);
            String methodCallerName = this.getMethodCallerName(firstChild);
            if (CheckstyleTestMakeupCheck.isAddPropertyMethod(methodCallName) && this.checkConfigNames.contains(methodCallerName)) {
                DetailAST elist = ast.findFirstToken(34);
                for (DetailAST expression = elist.getFirstChild(); expression != null; expression = expression.getNextSibling()) {
                    if (expression.getType() != 28 || this.isValidMethodCallExpression(expression.getFirstChild())) continue;
                    this.violations.put(expression, MSG_KEY_UNKNOWN_PROPERTY);
                }
            } else if (methodCallerName.equals(methodCallName) && ast.getParent().getParent().getType() != 27 && this.verifyMethodRegexp.matcher(methodCallName).matches()) {
                this.foundVerify = true;
            }
        }
    }

    private static boolean isAddPropertyMethod(String methodName) {
        return "addAttribute".equals(methodName) || "addProperty".equals(methodName);
    }

    private String getMethodCallName(DetailAST ast) {
        String result = ast.getType() == 59 ? this.getMethodCallName(ast.getFirstChild().getNextSibling()) : ast.getText();
        return result;
    }

    private String getMethodCallerName(DetailAST ast) {
        String result = ast.getType() == 59 ? this.getMethodCallName(ast.getFirstChild()) : ast.getText();
        return result;
    }

    private boolean isValidMethodCallExpression(DetailAST expression) {
        boolean result = false;
        DetailAST firstChild = expression.getFirstChild();
        switch (expression.getType()) {
            case 139: {
                result = true;
                break;
            }
            case 27: {
                result = this.isValidMethodCallExpressionMethodCall(firstChild);
                break;
            }
            case 125: {
                result = this.isValidMethodCallExpression(firstChild) && this.isValidMethodCallExpression(firstChild.getNextSibling());
                break;
            }
            case 135: {
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean isValidMethodCallExpressionMethodCall(DetailAST firstChild) {
        boolean result = false;
        if (firstChild.getType() == 59) {
            if (firstChild.getFirstChild().getType() == 59) {
                result = CheckstyleTestMakeupCheck.isEnumerationCall(firstChild);
            } else if (this.isFileVariable(firstChild.getFirstChild())) {
                result = true;
            }
        } else {
            String methodName = firstChild.getText();
            if (CheckstyleTestMakeupCheck.isMethodGetPath(methodName)) {
                result = true;
            }
        }
        return result;
    }

    private static boolean isEnumerationCall(DetailAST ast) {
        boolean result = false;
        DetailAST firstChild = ast.getFirstChild();
        DetailAST methodCalled = firstChild.getNextSibling();
        DetailAST parameters = ast.getNextSibling();
        if (firstChild.getFirstChild().getType() == 58 && ("toString".equals(methodCalled.getText()) || "getName".equals(methodCalled.getText()) || "name".equals(methodCalled.getText())) && parameters.getChildCount() == 0) {
            result = true;
        }
        return result;
    }

    private boolean isFileVariable(DetailAST firstChild) {
        return METHOD_GET_PATH.equals(firstChild.getNextSibling().getText()) && this.fileVariableNames.contains(firstChild.getText());
    }

    private static boolean isMethodGetPath(String methodName) {
        return METHOD_GET_PATH.equals(methodName) || "getNonCompilablePath".equals(methodName) || "getUriString".equals(methodName) || "getResourcePath".equals(methodName);
    }

    public void leaveToken(DetailAST ast) {
        if (ast == this.methodAst) {
            if (this.foundVerify) {
                if (this.checkConfigNames.isEmpty()) {
                    this.violations.put(ast, MSG_KEY_CONFIG_NOT_FOUND);
                }
                for (Map.Entry<DetailAST, String> entry : this.violations.entrySet()) {
                    this.log(entry.getKey(), entry.getValue(), new Object[0]);
                }
            }
            this.resetInternalFields();
        }
    }

    private void resetInternalFields() {
        this.methodAst = null;
        this.fileVariableNames.clear();
        this.checkConfigNames.clear();
        this.foundVerify = false;
        this.violations.clear();
    }
}

