/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

import com.power.common.util.DateTimeUtil;
import com.power.common.util.UUIDUtil;
import java.text.DecimalFormat;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Random;

public class RandomUtil {
    private static final String BASE_NUMBER = "0123456789";
    private static final String BASE_CHAR = "abcdefghijklmnopqrstuvwxyz";
    private static final String BASE_CHAR_NUMBER = "abcdefghijklmnopqrstuvwxyz0123456789";
    private static final String FORMAT = "0.00";
    private static final Random random = new Random();

    public static int randomInt(int min, int max) {
        return random.nextInt(max - min) + min;
    }

    public static int randomInt(int limit) {
        return random.nextInt(limit);
    }

    public static int randomInt() {
        return random.nextInt();
    }

    public static long randomLong() {
        return random.nextLong();
    }

    public static long randomLong(long min, long max) {
        return min + (long)(new Random().nextDouble() * (double)(max - min));
    }

    public static String randomString(int length) {
        return RandomUtil.randomString(BASE_CHAR_NUMBER, length);
    }

    public static String randomNumbers(int length) {
        return RandomUtil.randomString(BASE_NUMBER, length);
    }

    public static String randomString(String baseString, int length) {
        StringBuilder sb = new StringBuilder();
        if (length < 1) {
            length = 1;
        }
        int baseLength = baseString.length();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(baseLength);
            sb.append(baseString.charAt(number));
        }
        return sb.toString();
    }

    public static double randomDouble(double min, double max) {
        return min + (max - min) * random.nextDouble();
    }

    public static double randomDouble() {
        return RandomUtil.randomDouble(0.0, 100.0);
    }

    public static String randomDouble(String format) {
        return new DecimalFormat(format).format(RandomUtil.randomDouble());
    }

    public static String randomValueByType(String type) {
        switch (type) {
            case "char": {
                return RandomUtil.randomString(1);
            }
            case "Integer": 
            case "int": 
            case "Long": 
            case "long": 
            case "BigDecimal": 
            case "BigInteger": {
                return String.valueOf(RandomUtil.randomInt(1000));
            }
            case "Double": 
            case "double": 
            case "Float": 
            case "float": {
                return String.valueOf(RandomUtil.randomDouble(FORMAT));
            }
            case "short": 
            case "Short": {
                return String.valueOf(RandomUtil.randomInt(0, Short.MAX_VALUE));
            }
            case "Byte": 
            case "byte": {
                return String.valueOf(RandomUtil.randomInt(0, 127));
            }
            case "boolean": 
            case "Boolean": {
                return "true";
            }
            case "Time": 
            case "Date": {
                return DateTimeUtil.dateToStr(new Date(), "yyyy-MM-dd HH:mm:ss");
            }
            case "LocalTime": {
                return DateTimeUtil.dateToStr(new Date(), "HH:mm:ss");
            }
            case "Year": {
                return DateTimeUtil.dateToStr(new Date(), "yyyy");
            }
            case "MonthDay": {
                return DateTimeUtil.dateToStr(new Date(), "MM-dd");
            }
            case "YearMonth": {
                return DateTimeUtil.dateToStr(new Date(), "yyyy-MM");
            }
            case "LocalDate": {
                return DateTimeUtil.long2Str(System.currentTimeMillis(), "yyyy-MM-dd");
            }
            case "Timestamp": 
            case "LocalDateTime": {
                return DateTimeUtil.long2Str(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss");
            }
            case "ZonedDateTime": {
                return DateTimeUtil.zonedDateTimeToStr(ZonedDateTime.now(), "yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
            }
            case "OffsetDateTime": {
                return OffsetDateTime.now().toString();
            }
            case "uuid": 
            case "UUID": {
                return UUIDUtil.getUuid();
            }
        }
        return RandomUtil.randomString(6);
    }
}

